/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryArtifactEventTarget;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventConnectedRegistry;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class ContainerRegistryArtifactEventData
implements JsonSerializable<ContainerRegistryArtifactEventData> {
    private String id;
    private OffsetDateTime timestamp;
    private String action;
    private String location;
    private ContainerRegistryArtifactEventTarget target;
    private ContainerRegistryEventConnectedRegistry connectedRegistry;

    public String getId() {
        return this.id;
    }

    public ContainerRegistryArtifactEventData setId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public ContainerRegistryArtifactEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public ContainerRegistryArtifactEventData setAction(String action) {
        this.action = action;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ContainerRegistryArtifactEventData setLocation(String location) {
        this.location = location;
        return this;
    }

    public ContainerRegistryArtifactEventTarget getTarget() {
        return this.target;
    }

    public ContainerRegistryArtifactEventData setTarget(ContainerRegistryArtifactEventTarget target) {
        this.target = target;
        return this;
    }

    public ContainerRegistryEventConnectedRegistry getConnectedRegistry() {
        return this.connectedRegistry;
    }

    public ContainerRegistryArtifactEventData setConnectedRegistry(ContainerRegistryEventConnectedRegistry connectedRegistry) {
        this.connectedRegistry = connectedRegistry;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeJsonField("connectedRegistry", (JsonSerializable)this.connectedRegistry);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryArtifactEventData fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryArtifactEventData)jsonReader.readObject(reader -> {
            ContainerRegistryArtifactEventData deserializedContainerRegistryArtifactEventData = new ContainerRegistryArtifactEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.id = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.action = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.location = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.target = ContainerRegistryArtifactEventTarget.fromJson(reader);
                    continue;
                }
                if ("connectedRegistry".equals(fieldName)) {
                    deserializedContainerRegistryArtifactEventData.connectedRegistry = ContainerRegistryEventConnectedRegistry.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryArtifactEventData;
        });
    }
}

