/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class AcsRouterJobSchedulingFailedEventData
extends AcsRouterJobEventData {
    private Integer priority;
    private List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors;
    private List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors;
    private OffsetDateTime scheduledOn;
    private String failureReason;

    public Integer getPriority() {
        return this.priority;
    }

    public AcsRouterJobSchedulingFailedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<AcsRouterWorkerSelector> getExpiredAttachedWorkerSelectors() {
        return this.expiredAttachedWorkerSelectors;
    }

    public AcsRouterJobSchedulingFailedEventData setExpiredAttachedWorkerSelectors(List<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors) {
        this.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors;
        return this;
    }

    public List<AcsRouterWorkerSelector> getExpiredRequestedWorkerSelectors() {
        return this.expiredRequestedWorkerSelectors;
    }

    public AcsRouterJobSchedulingFailedEventData setExpiredRequestedWorkerSelectors(List<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors) {
        this.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors;
        return this;
    }

    public OffsetDateTime getScheduledOn() {
        return this.scheduledOn;
    }

    public AcsRouterJobSchedulingFailedEventData setScheduledOn(OffsetDateTime scheduledOn) {
        this.scheduledOn = scheduledOn;
        return this;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public AcsRouterJobSchedulingFailedEventData setFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobSchedulingFailedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("expiredAttachedWorkerSelectors", this.expiredAttachedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("expiredRequestedWorkerSelectors", this.expiredRequestedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("scheduledOn", this.scheduledOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledOn));
        jsonWriter.writeStringField("failureReason", this.failureReason);
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobSchedulingFailedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobSchedulingFailedEventData)jsonReader.readObject(reader -> {
            AcsRouterJobSchedulingFailedEventData deserializedAcsRouterJobSchedulingFailedEventData = new AcsRouterJobSchedulingFailedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobSchedulingFailedEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobSchedulingFailedEventData.setTags(tags);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("expiredAttachedWorkerSelectors".equals(fieldName)) {
                    List expiredAttachedWorkerSelectors;
                    deserializedAcsRouterJobSchedulingFailedEventData.expiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("expiredRequestedWorkerSelectors".equals(fieldName)) {
                    List expiredRequestedWorkerSelectors;
                    deserializedAcsRouterJobSchedulingFailedEventData.expiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("scheduledOn".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.scheduledOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("failureReason".equals(fieldName)) {
                    deserializedAcsRouterJobSchedulingFailedEventData.failureReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobSchedulingFailedEventData;
        });
    }
}

