/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatTypingIndicatorReceivedInThreadEventData
extends AcsChatMessageEventInThreadBaseProperties {
    private String messageBody;
    private Map<String, String> metadata;

    public String getMessageBody() {
        return this.messageBody;
    }

    public AcsChatTypingIndicatorReceivedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatTypingIndicatorReceivedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatTypingIndicatorReceivedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatTypingIndicatorReceivedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatTypingIndicatorReceivedInThreadEventData)jsonReader.readObject(reader -> {
            AcsChatTypingIndicatorReceivedInThreadEventData deserializedAcsChatTypingIndicatorReceivedInThreadEventData = new AcsChatTypingIndicatorReceivedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setType(reader.getString());
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.messageBody = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatTypingIndicatorReceivedInThreadEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatTypingIndicatorReceivedInThreadEventData;
        });
    }
}

