/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsCallEndReasonProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallEndedByProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallGroupProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallRoomProperties;
import com.azure.messaging.eventgrid.systemevents.AcsCallingEventProperties;
import java.io.IOException;
import java.time.Duration;

public final class AcsCallEndedEventData
extends AcsCallingEventProperties {
    private AcsCallEndedByProperties endedBy;
    private AcsCallEndReasonProperties reason;
    private Float callDurationInSeconds;

    public AcsCallEndedByProperties getEndedBy() {
        return this.endedBy;
    }

    public AcsCallEndedEventData setEndedBy(AcsCallEndedByProperties endedBy) {
        this.endedBy = endedBy;
        return this;
    }

    public AcsCallEndReasonProperties getReason() {
        return this.reason;
    }

    public AcsCallEndedEventData setReason(AcsCallEndReasonProperties reason) {
        this.reason = reason;
        return this;
    }

    public Duration getCallDuration() {
        if (this.callDurationInSeconds != null) {
            return Duration.ofNanos((long)(this.callDurationInSeconds.floatValue() * 1.0E9f));
        }
        return null;
    }

    public AcsCallEndedEventData setCallDuration(Duration callDuration) {
        this.callDurationInSeconds = callDuration != null ? Float.valueOf((float)callDuration.toNanos() / 1.0E9f) : null;
        return this;
    }

    @Override
    public AcsCallEndedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    @Override
    public AcsCallEndedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    @Override
    public AcsCallEndedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    @Override
    public AcsCallEndedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    @Override
    public AcsCallEndedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    @Override
    public AcsCallEndedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    @Override
    public AcsCallEndedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", (JsonSerializable)this.getStartedBy());
        jsonWriter.writeStringField("serverCallId", this.getServerCallId());
        jsonWriter.writeStringField("correlationId", this.getCorrelationId());
        jsonWriter.writeJsonField("group", (JsonSerializable)this.getGroup());
        jsonWriter.writeJsonField("room", (JsonSerializable)this.getRoom());
        jsonWriter.writeBooleanField("isTwoParty", this.isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", this.isRoomsCall());
        jsonWriter.writeJsonField("endedBy", (JsonSerializable)this.endedBy);
        jsonWriter.writeJsonField("reason", (JsonSerializable)this.reason);
        jsonWriter.writeNumberField("callDurationInSeconds", (Number)this.callDurationInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static AcsCallEndedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsCallEndedEventData)jsonReader.readObject(reader -> {
            AcsCallEndedEventData deserializedAcsCallEndedEventData = new AcsCallEndedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                    continue;
                }
                if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setServerCallId(reader.getString());
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setCorrelationId(reader.getString());
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                    continue;
                }
                if ("room".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                    continue;
                }
                if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setIsTwoParty((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setIsRoomsCall((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("endedBy".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.endedBy = AcsCallEndedByProperties.fromJson(reader);
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.reason = AcsCallEndReasonProperties.fromJson(reader);
                    continue;
                }
                if ("callDurationInSeconds".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.callDurationInSeconds = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsCallEndedEventData;
        });
    }
}

