/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.eventgrid.namespaces.EventGridServiceVersion;
import reactor.core.publisher.Mono;

public final class EventGridReceiverClientImpl {
    private final EventGridReceiverClientService service;
    private final String endpoint;
    private final EventGridServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public EventGridServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EventGridReceiverClientImpl(String endpoint, EventGridServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EventGridReceiverClientImpl(HttpPipeline httpPipeline, String endpoint, EventGridServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public EventGridReceiverClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, EventGridServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (EventGridReceiverClientService)RestProxy.create(EventGridReceiverClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> receiveWithResponseAsync(String topicName, String eventSubscriptionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.receive(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> receiveWithResponse(String topicName, String eventSubscriptionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.receiveSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> acknowledgeWithResponseAsync(String topicName, String eventSubscriptionName, BinaryData acknowledgeRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.acknowledge(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", acknowledgeRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> acknowledgeWithResponse(String topicName, String eventSubscriptionName, BinaryData acknowledgeRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.acknowledgeSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", acknowledgeRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> releaseWithResponseAsync(String topicName, String eventSubscriptionName, BinaryData releaseRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.release(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", releaseRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> releaseWithResponse(String topicName, String eventSubscriptionName, BinaryData releaseRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.releaseSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", releaseRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> rejectWithResponseAsync(String topicName, String eventSubscriptionName, BinaryData rejectRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reject(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", rejectRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> rejectWithResponse(String topicName, String eventSubscriptionName, BinaryData rejectRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.rejectSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", rejectRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> renewLocksWithResponseAsync(String topicName, String eventSubscriptionName, BinaryData renewLocksRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renewLocks(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", renewLocksRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> renewLocksWithResponse(String topicName, String eventSubscriptionName, BinaryData renewLocksRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.renewLocksSync(this.getEndpoint(), this.getServiceVersion().getVersion(), topicName, eventSubscriptionName, "application/json", "application/json", renewLocksRequest, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="EventGridReceiverCli")
    public static interface EventGridReceiverClientService {
        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:receive")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> receive(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:receive")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> receiveSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:acknowledge")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> acknowledge(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:acknowledge")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> acknowledgeSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> release(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> releaseSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:reject")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> reject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:reject")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> rejectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:renewLock")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> renewLocks(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/topics/{topicName}/eventsubscriptions/{eventSubscriptionName}:renewLock")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> renewLocksSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="topicName") String var3, @PathParam(value="eventSubscriptionName") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);
    }
}

