/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.messaging.eventgrid.namespaces.EventGridReceiverClient;
import com.azure.messaging.eventgrid.namespaces.EventGridReceiverClientBuilder;
import com.azure.messaging.eventgrid.namespaces.implementation.EventGridReceiverClientImpl;
import com.azure.messaging.eventgrid.namespaces.implementation.models.AcknowledgeRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.RejectRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.ReleaseRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.RenewLocksRequest;
import com.azure.messaging.eventgrid.namespaces.models.AcknowledgeResult;
import com.azure.messaging.eventgrid.namespaces.models.ReceiveResult;
import com.azure.messaging.eventgrid.namespaces.models.RejectResult;
import com.azure.messaging.eventgrid.namespaces.models.ReleaseDelay;
import com.azure.messaging.eventgrid.namespaces.models.ReleaseResult;
import com.azure.messaging.eventgrid.namespaces.models.RenewLocksResult;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EventGridReceiverClientBuilder.class, isAsync=true)
public final class EventGridReceiverAsyncClient {
    private final EventGridReceiverClientImpl serviceClient;
    private final String topicName;
    private final String subscriptionName;

    EventGridReceiverAsyncClient(EventGridReceiverClientImpl serviceClient, String topicName, String subscriptionName) {
        this.serviceClient = serviceClient;
        this.topicName = topicName;
        this.subscriptionName = subscriptionName;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> receiveWithResponse(String topicName, String eventSubscriptionName, RequestOptions requestOptions) {
        return this.serviceClient.receiveWithResponseAsync(topicName, eventSubscriptionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> acknowledgeWithResponse(String topicName, String eventSubscriptionName, BinaryData acknowledgeRequest, RequestOptions requestOptions) {
        return this.serviceClient.acknowledgeWithResponseAsync(topicName, eventSubscriptionName, acknowledgeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> releaseWithResponse(String topicName, String eventSubscriptionName, BinaryData releaseRequest, RequestOptions requestOptions) {
        return this.serviceClient.releaseWithResponseAsync(topicName, eventSubscriptionName, releaseRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> rejectWithResponse(String topicName, String eventSubscriptionName, BinaryData rejectRequest, RequestOptions requestOptions) {
        return this.serviceClient.rejectWithResponseAsync(topicName, eventSubscriptionName, rejectRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> renewLocksWithResponse(String topicName, String eventSubscriptionName, BinaryData renewLocksRequest, RequestOptions requestOptions) {
        return this.serviceClient.renewLocksWithResponseAsync(topicName, eventSubscriptionName, renewLocksRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReceiveResult> receive(Integer maxEvents, Duration maxWaitTime) {
        RequestOptions requestOptions = new RequestOptions();
        if (maxEvents != null) {
            requestOptions.addQueryParam("maxEvents", String.valueOf(maxEvents), false);
        }
        if (maxWaitTime != null) {
            return this.receiveWithResponse(maxEvents, maxWaitTime, new RequestOptions()).map(Response::getValue);
        }
        return this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ReceiveResult)protocolMethodData.toObject(ReceiveResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReceiveResult>> receiveWithResponse(Integer maxEvents, Duration maxWaitTime, RequestOptions requestOptions) {
        if (maxEvents != null) {
            requestOptions.addQueryParam("maxEvents", String.valueOf(maxEvents), false);
        }
        if (maxWaitTime != null) {
            EventGridReceiverClient.addTimeoutToContext(requestOptions, maxWaitTime);
            requestOptions.addQueryParam("maxWaitTime", String.valueOf(maxWaitTime.getSeconds()), false);
        } else {
            EventGridReceiverClient.addTimeoutToContext(requestOptions, Duration.ofSeconds(65L));
        }
        return this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions).map(response -> new SimpleResponse(response, (Object)((ReceiveResult)((BinaryData)response.getValue()).toObject(ReceiveResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReceiveResult> receive() {
        RequestOptions requestOptions = new RequestOptions();
        return this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ReceiveResult)protocolMethodData.toObject(ReceiveResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AcknowledgeResult> acknowledge(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        AcknowledgeRequest requestObj = new AcknowledgeRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.acknowledgeWithResponse(this.topicName, this.subscriptionName, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AcknowledgeResult)protocolMethodData.toObject(AcknowledgeResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AcknowledgeResult>> acknowledgeWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        AcknowledgeRequest requestObj = new AcknowledgeRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.acknowledgeWithResponse(this.topicName, this.subscriptionName, request, requestOptions).map(response -> new SimpleResponse(response, (Object)((AcknowledgeResult)((BinaryData)response.getValue()).toObject(AcknowledgeResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseResult> release(List<String> lockTokens, ReleaseDelay releaseDelay) {
        RequestOptions requestOptions = new RequestOptions();
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        if (releaseDelay != null) {
            requestOptions.addQueryParam("releaseDelayInSeconds", releaseDelay.toString(), false);
        }
        return this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ReleaseResult)protocolMethodData.toObject(ReleaseResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseResult>> releaseWithResponse(List<String> lockTokens, ReleaseDelay releaseDelay, RequestOptions requestOptions) {
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        if (releaseDelay != null) {
            requestOptions.addQueryParam("releaseDelayInSeconds", releaseDelay.toString(), false);
        }
        return this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions).map(response -> new SimpleResponse(response, (Object)((ReleaseResult)((BinaryData)response.getValue()).toObject(ReleaseResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseResult> release(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ReleaseResult)protocolMethodData.toObject(ReleaseResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RejectResult> reject(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        RejectRequest requestObj = new RejectRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.rejectWithResponse(this.topicName, this.subscriptionName, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RejectResult)protocolMethodData.toObject(RejectResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RejectResult>> rejectWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        RejectRequest requestObj = new RejectRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.rejectWithResponse(this.topicName, this.subscriptionName, request, requestOptions).map(response -> new SimpleResponse(response, (Object)((RejectResult)((BinaryData)response.getValue()).toObject(RejectResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RenewLocksResult> renewLocks(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        RenewLocksRequest requestObj = new RenewLocksRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.renewLocksWithResponse(this.topicName, this.subscriptionName, request, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RenewLocksResult)protocolMethodData.toObject(RenewLocksResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RenewLocksResult>> renewLocksWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        RenewLocksRequest requestObj = new RenewLocksRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return this.renewLocksWithResponse(this.topicName, this.subscriptionName, request, requestOptions).map(protocolMethodData -> new SimpleResponse(protocolMethodData, (Object)((RenewLocksResult)((BinaryData)protocolMethodData.getValue()).toObject(RenewLocksResult.class))));
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }
}

