/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.messaging.eventgrid.namespaces.EventGridReceiverClientBuilder;
import com.azure.messaging.eventgrid.namespaces.implementation.EventGridReceiverClientImpl;
import com.azure.messaging.eventgrid.namespaces.implementation.models.AcknowledgeRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.RejectRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.ReleaseRequest;
import com.azure.messaging.eventgrid.namespaces.implementation.models.RenewLocksRequest;
import com.azure.messaging.eventgrid.namespaces.models.AcknowledgeResult;
import com.azure.messaging.eventgrid.namespaces.models.ReceiveResult;
import com.azure.messaging.eventgrid.namespaces.models.RejectResult;
import com.azure.messaging.eventgrid.namespaces.models.ReleaseDelay;
import com.azure.messaging.eventgrid.namespaces.models.ReleaseResult;
import com.azure.messaging.eventgrid.namespaces.models.RenewLocksResult;
import java.time.Duration;
import java.util.List;

@ServiceClient(builder=EventGridReceiverClientBuilder.class)
public final class EventGridReceiverClient {
    private final EventGridReceiverClientImpl serviceClient;
    private final String topicName;
    private final String subscriptionName;

    EventGridReceiverClient(EventGridReceiverClientImpl serviceClient, String topicName, String subscriptionName) {
        this.serviceClient = serviceClient;
        this.topicName = topicName;
        this.subscriptionName = subscriptionName;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> receiveWithResponse(String topicName, String eventSubscriptionName, RequestOptions requestOptions) {
        return this.serviceClient.receiveWithResponse(topicName, eventSubscriptionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> acknowledgeWithResponse(String topicName, String eventSubscriptionName, BinaryData acknowledgeRequest, RequestOptions requestOptions) {
        return this.serviceClient.acknowledgeWithResponse(topicName, eventSubscriptionName, acknowledgeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> releaseWithResponse(String topicName, String eventSubscriptionName, BinaryData releaseRequest, RequestOptions requestOptions) {
        return this.serviceClient.releaseWithResponse(topicName, eventSubscriptionName, releaseRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> rejectWithResponse(String topicName, String eventSubscriptionName, BinaryData rejectRequest, RequestOptions requestOptions) {
        return this.serviceClient.rejectWithResponse(topicName, eventSubscriptionName, rejectRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> renewLocksWithResponse(String topicName, String eventSubscriptionName, BinaryData renewLocksRequest, RequestOptions requestOptions) {
        return this.serviceClient.renewLocksWithResponse(topicName, eventSubscriptionName, renewLocksRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReceiveResult receive(Integer maxEvents, Duration maxWaitTime) {
        RequestOptions requestOptions = new RequestOptions();
        if (maxEvents != null) {
            requestOptions.addQueryParam("maxEvents", String.valueOf(maxEvents), false);
        }
        if (maxWaitTime != null) {
            return (ReceiveResult)this.receiveWithResponse(maxEvents, maxWaitTime, new RequestOptions()).getValue();
        }
        return (ReceiveResult)((BinaryData)this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions).getValue()).toObject(ReceiveResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReceiveResult> receiveWithResponse(Integer maxEvents, Duration maxWaitTime, RequestOptions requestOptions) {
        if (maxEvents != null) {
            requestOptions.addQueryParam("maxEvents", String.valueOf(maxEvents), false);
        }
        if (maxWaitTime != null) {
            EventGridReceiverClient.addTimeoutToContext(requestOptions, maxWaitTime);
            requestOptions.addQueryParam("maxWaitTime", String.valueOf(maxWaitTime.getSeconds()), false);
        } else {
            EventGridReceiverClient.addTimeoutToContext(requestOptions, Duration.ofSeconds(65L));
        }
        Response<BinaryData> response = this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions);
        return new SimpleResponse(response, (Object)((ReceiveResult)((BinaryData)response.getValue()).toObject(ReceiveResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReceiveResult receive() {
        RequestOptions requestOptions = new RequestOptions();
        return (ReceiveResult)((BinaryData)this.receiveWithResponse(this.topicName, this.subscriptionName, requestOptions).getValue()).toObject(ReceiveResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AcknowledgeResult acknowledge(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        AcknowledgeRequest requestObj = new AcknowledgeRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (AcknowledgeResult)((BinaryData)this.acknowledgeWithResponse(this.topicName, this.subscriptionName, request, requestOptions).getValue()).toObject(AcknowledgeResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AcknowledgeResult> acknowledgeWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        AcknowledgeRequest requestObj = new AcknowledgeRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        Response<BinaryData> response = this.acknowledgeWithResponse(this.topicName, this.subscriptionName, request, requestOptions);
        return new SimpleResponse(response, (Object)((AcknowledgeResult)((BinaryData)response.getValue()).toObject(AcknowledgeResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseResult release(List<String> lockTokens, ReleaseDelay releaseDelay) {
        RequestOptions requestOptions = new RequestOptions();
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        if (releaseDelay != null) {
            requestOptions.addQueryParam("releaseDelayInSeconds", releaseDelay.toString(), false);
        }
        return (ReleaseResult)((BinaryData)this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions).getValue()).toObject(ReleaseResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReleaseResult> releaseWithResponse(List<String> lockTokens, ReleaseDelay releaseDelay, RequestOptions requestOptions) {
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        if (releaseDelay != null) {
            requestOptions.addQueryParam("releaseDelayInSeconds", releaseDelay.toString(), false);
        }
        Response<BinaryData> response = this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions);
        return new SimpleResponse(response, (Object)((ReleaseResult)((BinaryData)response.getValue()).toObject(ReleaseResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseResult release(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        ReleaseRequest requestObj = new ReleaseRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (ReleaseResult)((BinaryData)this.releaseWithResponse(this.topicName, this.subscriptionName, request, requestOptions).getValue()).toObject(ReleaseResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RejectResult reject(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        RejectRequest requestObj = new RejectRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (RejectResult)((BinaryData)this.rejectWithResponse(this.topicName, this.subscriptionName, request, requestOptions).getValue()).toObject(RejectResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RejectResult> rejectWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        RejectRequest requestObj = new RejectRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        Response<BinaryData> response = this.rejectWithResponse(this.topicName, this.subscriptionName, request, requestOptions);
        return new SimpleResponse(response, (Object)((RejectResult)((BinaryData)response.getValue()).toObject(RejectResult.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RenewLocksResult renewLocks(List<String> lockTokens) {
        RequestOptions requestOptions = new RequestOptions();
        RenewLocksRequest requestObj = new RenewLocksRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        return (RenewLocksResult)((BinaryData)this.renewLocksWithResponse(this.topicName, this.subscriptionName, request, requestOptions).getValue()).toObject(RenewLocksResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RenewLocksResult> renewLocksWithResponse(List<String> lockTokens, RequestOptions requestOptions) {
        RenewLocksRequest requestObj = new RenewLocksRequest(lockTokens);
        BinaryData request = BinaryData.fromObject((Object)requestObj);
        Response<BinaryData> response = this.renewLocksWithResponse(this.topicName, this.subscriptionName, request, requestOptions);
        return new SimpleResponse(response, (Object)((RenewLocksResult)((BinaryData)response.getValue()).toObject(RenewLocksResult.class)));
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    static void addTimeoutToContext(RequestOptions requestOptions, Duration timeout) {
        Context context = requestOptions.getContext();
        context = context == null ? new Context((Object)"azure-response-timeout", (Object)timeout.plusSeconds(5L)) : context.addData((Object)"azure-response-timeout", (Object)timeout.plusSeconds(5L));
        requestOptions.setContext(context);
    }
}

