/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import com.azure.iot.deviceupdate.implementation.DeviceUpdateClientImpl;
import com.azure.iot.deviceupdate.implementation.OperationResourcePollingStrategyWithEndpoint;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DeviceUpdatesImpl {
    private final DeviceUpdatesService service;
    private final DeviceUpdateClientImpl client;

    DeviceUpdatesImpl(DeviceUpdateClientImpl client) {
        this.service = (DeviceUpdatesService)RestProxy.create(DeviceUpdatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listUpdatesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUpdates(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listUpdatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listUpdatesSinglePageAsync(requestOptions), nextLink -> this.listUpdatesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listUpdates(RequestOptions requestOptions) {
        return new PagedIterable(this.listUpdatesAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> importUpdateWithResponseAsync(BinaryData updateToImport, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.importUpdate(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), updateToImport, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportUpdateAsync(BinaryData updateToImport, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.importUpdateWithResponseAsync(updateToImport, requestOptions), new OperationResourcePollingStrategyWithEndpoint(this.client.getHttpPipeline(), "https://" + this.client.getEndpoint(), null, null, requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportUpdate(BinaryData updateToImport, RequestOptions requestOptions) {
        return this.beginImportUpdateAsync(updateToImport, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateWithResponseAsync(String provider, String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdate(this.client.getEndpoint(), this.client.getInstanceId(), provider, name, version, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateWithResponse(String provider, String name, String version, RequestOptions requestOptions) {
        return (Response)this.getUpdateWithResponseAsync(provider, name, version, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteUpdateWithResponseAsync(String provider, String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteUpdate(this.client.getEndpoint(), this.client.getInstanceId(), provider, name, version, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginDeleteUpdateAsync(String provider, String name, String version, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.deleteUpdateWithResponseAsync(provider, name, version, requestOptions), new OperationResourcePollingStrategyWithEndpoint(this.client.getHttpPipeline(), "https://" + this.client.getEndpoint(), null, null, requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginDeleteUpdate(String provider, String name, String version, RequestOptions requestOptions) {
        return this.beginDeleteUpdateAsync(provider, name, version, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listProvidersSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listProviders(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listProvidersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listProvidersSinglePageAsync(requestOptions), nextLink -> this.listProvidersNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listProviders(RequestOptions requestOptions) {
        return new PagedIterable(this.listProvidersAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listNamesSinglePageAsync(String provider, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNames(this.client.getEndpoint(), this.client.getInstanceId(), provider, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNamesAsync(String provider, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listNamesSinglePageAsync(provider, requestOptions), nextLink -> this.listNamesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNames(String provider, RequestOptions requestOptions) {
        return new PagedIterable(this.listNamesAsync(provider, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listVersionsSinglePageAsync(String provider, String name, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listVersions(this.client.getEndpoint(), this.client.getInstanceId(), provider, name, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVersionsAsync(String provider, String name, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listVersionsSinglePageAsync(provider, name, requestOptions), nextLink -> this.listVersionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVersions(String provider, String name, RequestOptions requestOptions) {
        return new PagedIterable(this.listVersionsAsync(provider, name, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listFilesSinglePageAsync(String provider, String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFiles(this.client.getEndpoint(), this.client.getInstanceId(), provider, name, version, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listFilesAsync(String provider, String name, String version, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listFilesSinglePageAsync(provider, name, version, requestOptions), nextLink -> this.listFilesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listFiles(String provider, String name, String version, RequestOptions requestOptions) {
        return new PagedIterable(this.listFilesAsync(provider, name, version, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileWithResponseAsync(String provider, String name, String version, String fileId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFile(this.client.getEndpoint(), this.client.getInstanceId(), provider, name, version, fileId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String provider, String name, String version, String fileId, RequestOptions requestOptions) {
        return (Response)this.getFileWithResponseAsync(provider, name, version, fileId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationStatusesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperationStatuses(this.client.getEndpoint(), this.client.getInstanceId(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationStatusesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listOperationStatusesSinglePageAsync(requestOptions), nextLink -> this.listOperationStatusesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return new PagedIterable(this.listOperationStatusesAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationStatusWithResponseAsync(String operationId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationStatus(this.client.getEndpoint(), this.client.getInstanceId(), operationId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.getOperationStatusWithResponseAsync(operationId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listUpdatesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUpdatesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listProvidersNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listProvidersNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listNamesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNamesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listVersionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listVersionsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listFilesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFilesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationStatusesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperationStatusesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="DeviceUpdateClientDe")
    public static interface DeviceUpdatesService {
        @Get(value="/deviceUpdate/{instanceId}/updates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listUpdates(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/deviceUpdate/{instanceId}/updates:import")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> importUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names/{name}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @PathParam(value="name") String var4, @PathParam(value="version") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Delete(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names/{name}/versions/{version}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @PathParam(value="name") String var4, @PathParam(value="version") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listProviders(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNames(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names/{name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listVersions(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @PathParam(value="name") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names/{name}/versions/{version}/files")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listFiles(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @PathParam(value="name") String var4, @PathParam(value="version") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Get(value="/deviceUpdate/{instanceId}/updates/providers/{provider}/names/{name}/versions/{version}/files/{fileId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getFile(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="provider") String var3, @PathParam(value="name") String var4, @PathParam(value="version") String var5, @PathParam(value="fileId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, RequestOptions var9, Context var10);

        @Get(value="/deviceUpdate/{instanceId}/updates/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listOperationStatuses(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/deviceUpdate/{instanceId}/updates/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getOperationStatus(@HostParam(value="endpoint") String var1, @PathParam(value="instanceId", encoded=true) String var2, @PathParam(value="operationId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listUpdatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listProvidersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listNamesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listFilesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listOperationStatusesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

