/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.iot.deviceupdate.DeviceManagementAsyncClient;
import com.azure.iot.deviceupdate.DeviceManagementClientBuilder;

@ServiceClient(builder=DeviceManagementClientBuilder.class)
public final class DeviceManagementClient {
    private final DeviceManagementAsyncClient client;

    DeviceManagementClient(DeviceManagementAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDeviceClasses(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceClassWithResponse(deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateDeviceClassWithResponse(String deviceClassId, BinaryData deviceClassPatch, RequestOptions requestOptions) {
        return (Response)this.client.updateDeviceClassWithResponse(deviceClassId, deviceClassPatch, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.deleteDeviceClassWithResponse(deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listInstallableUpdatesForDeviceClass(String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listInstallableUpdatesForDeviceClass(deviceClassId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevices(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDevices(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.client.beginImportDevices(importType, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceWithResponse(deviceId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceModuleWithResponse(String deviceId, String moduleId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceModuleWithResponse(deviceId, moduleId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return (Response)this.client.getUpdateComplianceWithResponse(requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listGroups(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listGroups(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.client.getGroupWithResponse(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.client.deleteGroupWithResponse(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceForGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return (Response)this.client.getUpdateComplianceForGroupWithResponse(groupId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listBestUpdatesForGroup(groupId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDeploymentsForGroup(groupId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.getDeploymentWithResponse(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDeploymentWithResponse(String groupId, String deploymentId, BinaryData deployment, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateDeploymentWithResponse(groupId, deploymentId, deployment, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.deleteDeploymentWithResponse(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentStatusWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.getDeploymentStatusWithResponse(groupId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClassSubgroupsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDeviceClassSubgroupsForGroup(groupId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.deleteDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupUpdateComplianceWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceClassSubgroupUpdateComplianceWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBestUpdatesForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return (Response)this.client.getBestUpdatesForDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForDeviceClassSubgroup(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDeploymentsForDeviceClassSubgroup(groupId, deviceClassId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.getDeploymentForDeviceClassSubgroupWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeploymentForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.deleteDeploymentForDeviceClassSubgroupWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopDeploymentWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.stopDeploymentWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> retryDeploymentWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.retryDeploymentWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupDeploymentStatusWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return (Response)this.client.getDeviceClassSubgroupDeploymentStatusWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceStatesForDeviceClassSubgroupDeployment(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listDeviceStatesForDeviceClassSubgroupDeployment(groupId, deviceClassId, deploymentId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.client.getOperationStatusWithResponse(operationId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listOperationStatuses(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> startLogCollectionWithResponse(String logCollectionId, BinaryData logCollection, RequestOptions requestOptions) {
        return (Response)this.client.startLogCollectionWithResponse(logCollectionId, logCollection, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return (Response)this.client.getLogCollectionWithResponse(logCollectionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLogCollections(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listLogCollections(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionDetailedStatusWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return (Response)this.client.getLogCollectionDetailedStatusWithResponse(logCollectionId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listHealthOfDevices(String filter, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listHealthOfDevices(filter, requestOptions));
    }
}

