/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.iot.deviceupdate.DeviceManagementAsyncClient;
import com.azure.iot.deviceupdate.DeviceManagementClient;
import com.azure.iot.deviceupdate.DeviceUpdateServiceVersion;
import com.azure.iot.deviceupdate.implementation.DeviceUpdateClientImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceClientBuilder(serviceClients={DeviceManagementClient.class, DeviceManagementAsyncClient.class})
public final class DeviceManagementClientBuilder
implements HttpTrait<DeviceManagementClientBuilder>,
ConfigurationTrait<DeviceManagementClientBuilder>,
TokenCredentialTrait<DeviceManagementClientBuilder>,
EndpointTrait<DeviceManagementClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://api.adu.microsoft.com/.default"};
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-iot-deviceupdate.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private String endpoint;
    private String instanceId;
    private DeviceUpdateServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;

    public DeviceManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public DeviceManagementClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public DeviceManagementClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public DeviceManagementClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public DeviceManagementClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public DeviceManagementClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public DeviceManagementClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public DeviceManagementClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public DeviceManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DeviceManagementClientBuilder instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public DeviceManagementClientBuilder serviceVersion(DeviceUpdateServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public DeviceManagementClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private DeviceUpdateClientImpl buildInnerClient() {
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        DeviceUpdateServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : DeviceUpdateServiceVersion.getLatest();
        DeviceUpdateClientImpl client = new DeviceUpdateClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, this.instanceId, localServiceVersion);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = new HttpHeaders();
        this.clientOptions.getHeaders().forEach(header -> headers.set(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        policies.add(new CookiePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        policies.addAll(this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).build();
        return httpPipeline;
    }

    public DeviceManagementAsyncClient buildAsyncClient() {
        return new DeviceManagementAsyncClient(this.buildInnerClient().getDeviceManagements());
    }

    public DeviceManagementClient buildClient() {
        return new DeviceManagementClient(new DeviceManagementAsyncClient(this.buildInnerClient().getDeviceManagements()));
    }
}

