/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.ResourceMetric;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TestServerMetricsConfiguration
implements JsonSerializable<TestServerMetricsConfiguration> {
    private String testId;
    private Map<String, ResourceMetric> metrics;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getTestId() {
        return this.testId;
    }

    public Map<String, ResourceMetric> getMetrics() {
        return this.metrics;
    }

    public TestServerMetricsConfiguration setMetrics(Map<String, ResourceMetric> metrics) {
        this.metrics = metrics;
        this.updatedProperties.add("metrics");
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("metrics")) {
            if (this.metrics == null) {
                jsonWriter.writeNullField("metrics");
            } else {
                jsonWriter.writeMapField("metrics", this.metrics, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getResourceMetricAccessor().prepareModelForJsonMergePatch((ResourceMetric)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getResourceMetricAccessor().prepareModelForJsonMergePatch((ResourceMetric)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestServerMetricsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TestServerMetricsConfiguration)jsonReader.readObject(reader -> {
            TestServerMetricsConfiguration deserializedTestServerMetricsConfiguration = new TestServerMetricsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("testId".equals(fieldName)) {
                    deserializedTestServerMetricsConfiguration.testId = reader.getString();
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    Map metrics;
                    deserializedTestServerMetricsConfiguration.metrics = metrics = reader.readMap(reader1 -> ResourceMetric.fromJson(reader1));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTestServerMetricsConfiguration.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedTestServerMetricsConfiguration.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedTestServerMetricsConfiguration.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedTestServerMetricsConfiguration.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestServerMetricsConfiguration;
        });
    }

    static {
        JsonMergePatchHelper.setTestServerMetricsConfigurationAccessor(new JsonMergePatchHelper.TestServerMetricsConfigurationAccessor(){

            @Override
            public TestServerMetricsConfiguration prepareModelForJsonMergePatch(TestServerMetricsConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestServerMetricsConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

