/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.CertificateType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class TestCertificate
implements JsonSerializable<TestCertificate> {
    private String value;
    private CertificateType type;
    private String name;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getValue() {
        return this.value;
    }

    public TestCertificate setValue(String value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    public CertificateType getType() {
        return this.type;
    }

    public TestCertificate setType(CertificateType type) {
        this.type = type;
        this.updatedProperties.add("type");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TestCertificate setName(String name) {
        this.name = name;
        this.updatedProperties.add("name");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("value")) {
            if (this.value == null) {
                jsonWriter.writeNullField("value");
            } else {
                jsonWriter.writeStringField("value", this.value);
            }
        }
        if (this.updatedProperties.contains("type")) {
            if (this.type == null) {
                jsonWriter.writeNullField("type");
            } else {
                jsonWriter.writeStringField("type", this.type.toString());
            }
        }
        if (this.updatedProperties.contains("name")) {
            if (this.name == null) {
                jsonWriter.writeNullField("name");
            } else {
                jsonWriter.writeStringField("name", this.name);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (TestCertificate)jsonReader.readObject(reader -> {
            TestCertificate deserializedTestCertificate = new TestCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedTestCertificate.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTestCertificate.type = CertificateType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTestCertificate.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestCertificate;
        });
    }

    static {
        JsonMergePatchHelper.setTestCertificateAccessor(new JsonMergePatchHelper.TestCertificateAccessor(){

            @Override
            public TestCertificate prepareModelForJsonMergePatch(TestCertificate model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestCertificate model) {
                return model.jsonMergePatch;
            }
        });
    }
}

