/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.AutoStopCriteria;
import com.azure.developer.loadtesting.models.LoadTestConfiguration;
import com.azure.developer.loadtesting.models.LoadTestKind;
import com.azure.developer.loadtesting.models.LoadTestingManagedIdentityType;
import com.azure.developer.loadtesting.models.PassFailCriteria;
import com.azure.developer.loadtesting.models.TestCertificate;
import com.azure.developer.loadtesting.models.TestInputArtifacts;
import com.azure.developer.loadtesting.models.TestSecret;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LoadTest
implements JsonSerializable<LoadTest> {
    private PassFailCriteria passFailCriteria;
    private AutoStopCriteria autoStopCriteria;
    private Map<String, TestSecret> secrets;
    private TestCertificate certificate;
    private Map<String, String> environmentVariables;
    private LoadTestConfiguration loadTestConfiguration;
    private String baselineTestRunId;
    private TestInputArtifacts inputArtifacts;
    private String testId;
    private String description;
    private String displayName;
    private String subnetId;
    private LoadTestKind kind;
    private Boolean publicIpDisabled;
    private String keyvaultReferenceIdentityType;
    private String keyvaultReferenceIdentityId;
    private LoadTestingManagedIdentityType metricsReferenceIdentityType;
    private String metricsReferenceIdentityId;
    private LoadTestingManagedIdentityType engineBuiltInIdentityType;
    private List<String> engineBuiltInIdentityIds;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public PassFailCriteria getPassFailCriteria() {
        return this.passFailCriteria;
    }

    public LoadTest setPassFailCriteria(PassFailCriteria passFailCriteria) {
        this.passFailCriteria = passFailCriteria;
        this.updatedProperties.add("passFailCriteria");
        return this;
    }

    public AutoStopCriteria getAutoStopCriteria() {
        return this.autoStopCriteria;
    }

    public LoadTest setAutoStopCriteria(AutoStopCriteria autoStopCriteria) {
        this.autoStopCriteria = autoStopCriteria;
        this.updatedProperties.add("autoStopCriteria");
        return this;
    }

    public Map<String, TestSecret> getSecrets() {
        return this.secrets;
    }

    public LoadTest setSecrets(Map<String, TestSecret> secrets) {
        this.secrets = secrets;
        this.updatedProperties.add("secrets");
        return this;
    }

    public TestCertificate getCertificate() {
        return this.certificate;
    }

    public LoadTest setCertificate(TestCertificate certificate) {
        this.certificate = certificate;
        this.updatedProperties.add("certificate");
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public LoadTest setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.updatedProperties.add("environmentVariables");
        return this;
    }

    public LoadTestConfiguration getLoadTestConfiguration() {
        return this.loadTestConfiguration;
    }

    public LoadTest setLoadTestConfiguration(LoadTestConfiguration loadTestConfiguration) {
        this.loadTestConfiguration = loadTestConfiguration;
        this.updatedProperties.add("loadTestConfiguration");
        return this;
    }

    public String getBaselineTestRunId() {
        return this.baselineTestRunId;
    }

    public LoadTest setBaselineTestRunId(String baselineTestRunId) {
        this.baselineTestRunId = baselineTestRunId;
        this.updatedProperties.add("baselineTestRunId");
        return this;
    }

    public TestInputArtifacts getInputArtifacts() {
        return this.inputArtifacts;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getDescription() {
        return this.description;
    }

    public LoadTest setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LoadTest setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public LoadTest setSubnetId(String subnetId) {
        this.subnetId = subnetId;
        this.updatedProperties.add("subnetId");
        return this;
    }

    public LoadTestKind getKind() {
        return this.kind;
    }

    public LoadTest setKind(LoadTestKind kind) {
        this.kind = kind;
        this.updatedProperties.add("kind");
        return this;
    }

    public Boolean isPublicIpDisabled() {
        return this.publicIpDisabled;
    }

    public LoadTest setPublicIpDisabled(Boolean publicIpDisabled) {
        this.publicIpDisabled = publicIpDisabled;
        this.updatedProperties.add("publicIpDisabled");
        return this;
    }

    public String getKeyvaultReferenceIdentityType() {
        return this.keyvaultReferenceIdentityType;
    }

    public LoadTest setKeyvaultReferenceIdentityType(String keyvaultReferenceIdentityType) {
        this.keyvaultReferenceIdentityType = keyvaultReferenceIdentityType;
        this.updatedProperties.add("keyvaultReferenceIdentityType");
        return this;
    }

    public String getKeyvaultReferenceIdentityId() {
        return this.keyvaultReferenceIdentityId;
    }

    public LoadTest setKeyvaultReferenceIdentityId(String keyvaultReferenceIdentityId) {
        this.keyvaultReferenceIdentityId = keyvaultReferenceIdentityId;
        this.updatedProperties.add("keyvaultReferenceIdentityId");
        return this;
    }

    public LoadTestingManagedIdentityType getMetricsReferenceIdentityType() {
        return this.metricsReferenceIdentityType;
    }

    public LoadTest setMetricsReferenceIdentityType(LoadTestingManagedIdentityType metricsReferenceIdentityType) {
        this.metricsReferenceIdentityType = metricsReferenceIdentityType;
        this.updatedProperties.add("metricsReferenceIdentityType");
        return this;
    }

    public String getMetricsReferenceIdentityId() {
        return this.metricsReferenceIdentityId;
    }

    public LoadTest setMetricsReferenceIdentityId(String metricsReferenceIdentityId) {
        this.metricsReferenceIdentityId = metricsReferenceIdentityId;
        this.updatedProperties.add("metricsReferenceIdentityId");
        return this;
    }

    public LoadTestingManagedIdentityType getEngineBuiltInIdentityType() {
        return this.engineBuiltInIdentityType;
    }

    public LoadTest setEngineBuiltInIdentityType(LoadTestingManagedIdentityType engineBuiltInIdentityType) {
        this.engineBuiltInIdentityType = engineBuiltInIdentityType;
        this.updatedProperties.add("engineBuiltInIdentityType");
        return this;
    }

    public List<String> getEngineBuiltInIdentityIds() {
        return this.engineBuiltInIdentityIds;
    }

    public LoadTest setEngineBuiltInIdentityIds(List<String> engineBuiltInIdentityIds) {
        this.engineBuiltInIdentityIds = engineBuiltInIdentityIds;
        this.updatedProperties.add("engineBuiltInIdentityIds");
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("passFailCriteria", (JsonSerializable)this.passFailCriteria);
        jsonWriter.writeJsonField("autoStopCriteria", (JsonSerializable)this.autoStopCriteria);
        jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
        jsonWriter.writeMapField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("loadTestConfiguration", (JsonSerializable)this.loadTestConfiguration);
        jsonWriter.writeStringField("baselineTestRunId", this.baselineTestRunId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeBooleanField("publicIPDisabled", this.publicIpDisabled);
        jsonWriter.writeStringField("keyvaultReferenceIdentityType", this.keyvaultReferenceIdentityType);
        jsonWriter.writeStringField("keyvaultReferenceIdentityId", this.keyvaultReferenceIdentityId);
        jsonWriter.writeStringField("metricsReferenceIdentityType", this.metricsReferenceIdentityType == null ? null : this.metricsReferenceIdentityType.toString());
        jsonWriter.writeStringField("metricsReferenceIdentityId", this.metricsReferenceIdentityId);
        jsonWriter.writeStringField("engineBuiltInIdentityType", this.engineBuiltInIdentityType == null ? null : this.engineBuiltInIdentityType.toString());
        jsonWriter.writeArrayField("engineBuiltInIdentityIds", this.engineBuiltInIdentityIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("passFailCriteria")) {
            if (this.passFailCriteria == null) {
                jsonWriter.writeNullField("passFailCriteria");
            } else {
                JsonMergePatchHelper.getPassFailCriteriaAccessor().prepareModelForJsonMergePatch(this.passFailCriteria, true);
                jsonWriter.writeJsonField("passFailCriteria", (JsonSerializable)this.passFailCriteria);
                JsonMergePatchHelper.getPassFailCriteriaAccessor().prepareModelForJsonMergePatch(this.passFailCriteria, false);
            }
        }
        if (this.updatedProperties.contains("autoStopCriteria")) {
            if (this.autoStopCriteria == null) {
                jsonWriter.writeNullField("autoStopCriteria");
            } else {
                JsonMergePatchHelper.getAutoStopCriteriaAccessor().prepareModelForJsonMergePatch(this.autoStopCriteria, true);
                jsonWriter.writeJsonField("autoStopCriteria", (JsonSerializable)this.autoStopCriteria);
                JsonMergePatchHelper.getAutoStopCriteriaAccessor().prepareModelForJsonMergePatch(this.autoStopCriteria, false);
            }
        }
        if (this.updatedProperties.contains("secrets")) {
            if (this.secrets == null) {
                jsonWriter.writeNullField("secrets");
            } else {
                jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getTestSecretAccessor().prepareModelForJsonMergePatch((TestSecret)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getTestSecretAccessor().prepareModelForJsonMergePatch((TestSecret)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        if (this.updatedProperties.contains("certificate")) {
            if (this.certificate == null) {
                jsonWriter.writeNullField("certificate");
            } else {
                JsonMergePatchHelper.getTestCertificateAccessor().prepareModelForJsonMergePatch(this.certificate, true);
                jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
                JsonMergePatchHelper.getTestCertificateAccessor().prepareModelForJsonMergePatch(this.certificate, false);
            }
        }
        if (this.updatedProperties.contains("environmentVariables")) {
            if (this.environmentVariables == null) {
                jsonWriter.writeNullField("environmentVariables");
            } else {
                jsonWriter.writeMapField("environmentVariables", this.environmentVariables, (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        if (this.updatedProperties.contains("loadTestConfiguration")) {
            if (this.loadTestConfiguration == null) {
                jsonWriter.writeNullField("loadTestConfiguration");
            } else {
                JsonMergePatchHelper.getLoadTestConfigurationAccessor().prepareModelForJsonMergePatch(this.loadTestConfiguration, true);
                jsonWriter.writeJsonField("loadTestConfiguration", (JsonSerializable)this.loadTestConfiguration);
                JsonMergePatchHelper.getLoadTestConfigurationAccessor().prepareModelForJsonMergePatch(this.loadTestConfiguration, false);
            }
        }
        if (this.updatedProperties.contains("baselineTestRunId")) {
            if (this.baselineTestRunId == null) {
                jsonWriter.writeNullField("baselineTestRunId");
            } else {
                jsonWriter.writeStringField("baselineTestRunId", this.baselineTestRunId);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("subnetId")) {
            if (this.subnetId == null) {
                jsonWriter.writeNullField("subnetId");
            } else {
                jsonWriter.writeStringField("subnetId", this.subnetId);
            }
        }
        if (this.updatedProperties.contains("kind")) {
            if (this.kind == null) {
                jsonWriter.writeNullField("kind");
            } else {
                jsonWriter.writeStringField("kind", this.kind.toString());
            }
        }
        if (this.updatedProperties.contains("publicIpDisabled")) {
            if (this.publicIpDisabled == null) {
                jsonWriter.writeNullField("publicIPDisabled");
            } else {
                jsonWriter.writeBooleanField("publicIPDisabled", this.publicIpDisabled);
            }
        }
        if (this.updatedProperties.contains("keyvaultReferenceIdentityType")) {
            if (this.keyvaultReferenceIdentityType == null) {
                jsonWriter.writeNullField("keyvaultReferenceIdentityType");
            } else {
                jsonWriter.writeStringField("keyvaultReferenceIdentityType", this.keyvaultReferenceIdentityType);
            }
        }
        if (this.updatedProperties.contains("keyvaultReferenceIdentityId")) {
            if (this.keyvaultReferenceIdentityId == null) {
                jsonWriter.writeNullField("keyvaultReferenceIdentityId");
            } else {
                jsonWriter.writeStringField("keyvaultReferenceIdentityId", this.keyvaultReferenceIdentityId);
            }
        }
        if (this.updatedProperties.contains("metricsReferenceIdentityType")) {
            if (this.metricsReferenceIdentityType == null) {
                jsonWriter.writeNullField("metricsReferenceIdentityType");
            } else {
                jsonWriter.writeStringField("metricsReferenceIdentityType", this.metricsReferenceIdentityType.toString());
            }
        }
        if (this.updatedProperties.contains("metricsReferenceIdentityId")) {
            if (this.metricsReferenceIdentityId == null) {
                jsonWriter.writeNullField("metricsReferenceIdentityId");
            } else {
                jsonWriter.writeStringField("metricsReferenceIdentityId", this.metricsReferenceIdentityId);
            }
        }
        if (this.updatedProperties.contains("engineBuiltInIdentityType")) {
            if (this.engineBuiltInIdentityType == null) {
                jsonWriter.writeNullField("engineBuiltInIdentityType");
            } else {
                jsonWriter.writeStringField("engineBuiltInIdentityType", this.engineBuiltInIdentityType.toString());
            }
        }
        if (this.updatedProperties.contains("engineBuiltInIdentityIds")) {
            if (this.engineBuiltInIdentityIds == null) {
                jsonWriter.writeNullField("engineBuiltInIdentityIds");
            } else {
                jsonWriter.writeArrayField("engineBuiltInIdentityIds", this.engineBuiltInIdentityIds, (writer, element) -> writer.writeString(element));
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LoadTest fromJson(JsonReader jsonReader) throws IOException {
        return (LoadTest)jsonReader.readObject(reader -> {
            LoadTest deserializedLoadTest = new LoadTest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("testId".equals(fieldName)) {
                    deserializedLoadTest.testId = reader.getString();
                    continue;
                }
                if ("passFailCriteria".equals(fieldName)) {
                    deserializedLoadTest.passFailCriteria = PassFailCriteria.fromJson(reader);
                    continue;
                }
                if ("autoStopCriteria".equals(fieldName)) {
                    deserializedLoadTest.autoStopCriteria = AutoStopCriteria.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    Map secrets;
                    deserializedLoadTest.secrets = secrets = reader.readMap(reader1 -> TestSecret.fromJson(reader1));
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedLoadTest.certificate = TestCertificate.fromJson(reader);
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    Map environmentVariables;
                    deserializedLoadTest.environmentVariables = environmentVariables = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("loadTestConfiguration".equals(fieldName)) {
                    deserializedLoadTest.loadTestConfiguration = LoadTestConfiguration.fromJson(reader);
                    continue;
                }
                if ("baselineTestRunId".equals(fieldName)) {
                    deserializedLoadTest.baselineTestRunId = reader.getString();
                    continue;
                }
                if ("inputArtifacts".equals(fieldName)) {
                    deserializedLoadTest.inputArtifacts = TestInputArtifacts.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedLoadTest.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedLoadTest.displayName = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedLoadTest.subnetId = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedLoadTest.kind = LoadTestKind.fromString(reader.getString());
                    continue;
                }
                if ("publicIPDisabled".equals(fieldName)) {
                    deserializedLoadTest.publicIpDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyvaultReferenceIdentityType".equals(fieldName)) {
                    deserializedLoadTest.keyvaultReferenceIdentityType = reader.getString();
                    continue;
                }
                if ("keyvaultReferenceIdentityId".equals(fieldName)) {
                    deserializedLoadTest.keyvaultReferenceIdentityId = reader.getString();
                    continue;
                }
                if ("metricsReferenceIdentityType".equals(fieldName)) {
                    deserializedLoadTest.metricsReferenceIdentityType = LoadTestingManagedIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("metricsReferenceIdentityId".equals(fieldName)) {
                    deserializedLoadTest.metricsReferenceIdentityId = reader.getString();
                    continue;
                }
                if ("engineBuiltInIdentityType".equals(fieldName)) {
                    deserializedLoadTest.engineBuiltInIdentityType = LoadTestingManagedIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("engineBuiltInIdentityIds".equals(fieldName)) {
                    List engineBuiltInIdentityIds;
                    deserializedLoadTest.engineBuiltInIdentityIds = engineBuiltInIdentityIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedLoadTest.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedLoadTest.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedLoadTest.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedLoadTest.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadTest;
        });
    }

    static {
        JsonMergePatchHelper.setLoadTestAccessor(new JsonMergePatchHelper.LoadTestAccessor(){

            @Override
            public LoadTest prepareModelForJsonMergePatch(LoadTest model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(LoadTest model) {
                return model.jsonMergePatch;
            }
        });
    }
}

