/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class FunctionFlexConsumptionResourceConfiguration
implements JsonSerializable<FunctionFlexConsumptionResourceConfiguration> {
    private long instanceMemoryMB;
    private Long httpConcurrency;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public long getInstanceMemoryMB() {
        return this.instanceMemoryMB;
    }

    public FunctionFlexConsumptionResourceConfiguration setInstanceMemoryMB(long instanceMemoryMB) {
        this.instanceMemoryMB = instanceMemoryMB;
        this.updatedProperties.add("instanceMemoryMB");
        return this;
    }

    public Long getHttpConcurrency() {
        return this.httpConcurrency;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("instanceMemoryMB", this.instanceMemoryMB);
        jsonWriter.writeNumberField("httpConcurrency", (Number)this.httpConcurrency);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("instanceMemoryMB")) {
            jsonWriter.writeLongField("instanceMemoryMB", this.instanceMemoryMB);
        }
        if (this.updatedProperties.contains("httpConcurrency")) {
            if (this.httpConcurrency == null) {
                jsonWriter.writeNullField("httpConcurrency");
            } else {
                jsonWriter.writeNumberField("httpConcurrency", (Number)this.httpConcurrency);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FunctionFlexConsumptionResourceConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionFlexConsumptionResourceConfiguration)jsonReader.readObject(reader -> {
            FunctionFlexConsumptionResourceConfiguration deserializedFunctionFlexConsumptionResourceConfiguration = new FunctionFlexConsumptionResourceConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("instanceMemoryMB".equals(fieldName)) {
                    deserializedFunctionFlexConsumptionResourceConfiguration.instanceMemoryMB = reader.getLong();
                    continue;
                }
                if ("httpConcurrency".equals(fieldName)) {
                    deserializedFunctionFlexConsumptionResourceConfiguration.httpConcurrency = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionFlexConsumptionResourceConfiguration;
        });
    }

    public FunctionFlexConsumptionResourceConfiguration setHttpConcurrency(Long httpConcurrency) {
        this.httpConcurrency = httpConcurrency;
        this.updatedProperties.add("httpConcurrency");
        return this;
    }

    static {
        JsonMergePatchHelper.setFunctionFlexConsumptionResourceConfigurationAccessor(new JsonMergePatchHelper.FunctionFlexConsumptionResourceConfigurationAccessor(){

            @Override
            public FunctionFlexConsumptionResourceConfiguration prepareModelForJsonMergePatch(FunctionFlexConsumptionResourceConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(FunctionFlexConsumptionResourceConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

