/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.loadtesting.LoadTestAdministrationClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.implementation.LoadTestAdministrationClientImpl;
import com.azure.developer.loadtesting.models.LoadTest;
import com.azure.developer.loadtesting.models.LoadTestingFileType;
import com.azure.developer.loadtesting.models.TestAppComponents;
import com.azure.developer.loadtesting.models.TestFileInfo;
import com.azure.developer.loadtesting.models.TestProfile;
import com.azure.developer.loadtesting.models.TestServerMetricsConfiguration;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LoadTestAdministrationClientBuilder.class, isAsync=true)
public final class LoadTestAdministrationAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(LoadTestAdministrationAsyncClient.class);
    private final LoadTestAdministrationClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponseAsync(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginUploadTestFile(String testId, String fileName, BinaryData body, RequestOptions fileUploadRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (fileUploadRequestOptions != null) {
            defaultRequestOptions.setContext(fileUploadRequestOptions.getContext());
        }
        return new PollerFlux(Duration.ofSeconds(2L), context -> this.uploadTestFileWithResponse(testId, fileName, body, fileUploadRequestOptions).flatMap(FluxUtil::toMono).flatMap(fileBinaryData -> PollingUtils.getPollResponseMono(() -> PollingUtils.getValidationStatus(fileBinaryData))).flatMap(fileValidationPollResp -> Mono.just((Object)((BinaryData)fileValidationPollResp.getValue()))), context -> this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).flatMap(FluxUtil::toMono).flatMap(fileBinaryData -> PollingUtils.getPollResponseMono(() -> PollingUtils.getValidationStatus(fileBinaryData))), (activationResponse, context) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), context -> this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<TestFileInfo, TestFileInfo> beginUploadTestFile(String testId, String fileName, BinaryData body) {
        return new PollerFlux(Duration.ofSeconds(2L), context -> this.uploadTestFile(testId, fileName, body), context -> this.getTestFile(testId, fileName).flatMap(fileResp -> PollingUtils.getPollResponseMono(() -> PollingUtils.getValidationStatus(fileResp))), (activationResponse, context) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), context -> this.getTestFile(testId, fileName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestFiles(String testId, RequestOptions requestOptions) {
        return this.serviceClient.listTestFilesAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateTestWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestWithResponseAsync(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getTestWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTests(RequestOptions requestOptions) {
        return this.serviceClient.listTestsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> uploadTestFileWithResponse(String testId, String fileName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadTestFileWithResponseAsync(testId, fileName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestFileWithResponseAsync(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestFileWithResponseAsync(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponseAsync(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponseAsync(testId, requestOptions);
    }

    LoadTestAdministrationAsyncClient(LoadTestAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateTestProfileWithResponse(String testProfileId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestProfileWithResponseAsync(testProfileId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestProfileWithResponse(String testProfileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestProfileWithResponseAsync(testProfileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestProfileWithResponse(String testProfileId, RequestOptions requestOptions) {
        return this.serviceClient.getTestProfileWithResponseAsync(testProfileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestProfiles(RequestOptions requestOptions) {
        return this.serviceClient.listTestProfilesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestAppComponents> createOrUpdateAppComponents(String testId, TestAppComponents body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestAppComponentsAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestAppComponentsAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateAppComponentsWithResponse(testId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestAppComponents)protocolMethodData.toObject(TestAppComponents.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestAppComponents> getAppComponents(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAppComponentsWithResponse(testId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestAppComponents)protocolMethodData.toObject(TestAppComponents.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestServerMetricsConfiguration> getServerMetricsConfig(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getServerMetricsConfigWithResponse(testId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestServerMetricsConfiguration)protocolMethodData.toObject(TestServerMetricsConfiguration.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadTest> getTest(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestWithResponse(testId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTest)protocolMethodData.toObject(LoadTest.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestFileInfo> getTestFile(String testId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestFileWithResponse(testId, fileName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestFileInfo)protocolMethodData.toObject(TestFileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TestFileInfo> listTestFiles(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestFiles(testId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (TestFileInfo)protocolMethodData.toObject(TestFileInfo.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LoadTest> listTests(String orderBy, String search, OffsetDateTime lastModifiedStartTime, OffsetDateTime lastModifiedEndTime) {
        RequestOptions requestOptions = new RequestOptions();
        if (orderBy != null) {
            requestOptions.addQueryParam("orderby", orderBy, false);
        }
        if (search != null) {
            requestOptions.addQueryParam("search", search, false);
        }
        if (lastModifiedStartTime != null) {
            requestOptions.addQueryParam("lastModifiedStartTime", String.valueOf(lastModifiedStartTime), false);
        }
        if (lastModifiedEndTime != null) {
            requestOptions.addQueryParam("lastModifiedEndTime", String.valueOf(lastModifiedEndTime), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTests(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (LoadTest)protocolMethodData.toObject(LoadTest.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LoadTest> listTests() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTests(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (LoadTest)protocolMethodData.toObject(LoadTest.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<TestFileInfo> uploadTestFile(String testId, String fileName, BinaryData body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.uploadTestFileWithResponse(testId, fileName, body, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestFileInfo)protocolMethodData.toObject(TestFileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTestFile(String testId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTestFileWithResponse(testId, fileName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTest(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTestWithResponse(testId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestProfile> createOrUpdateTestProfile(String testProfileId, TestProfile body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestProfileAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestProfileAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateTestProfileWithResponse(testProfileId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestProfile)protocolMethodData.toObject(TestProfile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTestProfile(String testProfileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTestProfileWithResponse(testProfileId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestProfile> getTestProfile(String testProfileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestProfileWithResponse(testProfileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestProfile)protocolMethodData.toObject(TestProfile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TestProfile> listTestProfiles() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestProfiles(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (TestProfile)protocolMethodData.toObject(TestProfile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TestProfile> listTestProfiles(OffsetDateTime lastModifiedStartTime, OffsetDateTime lastModifiedEndTime, List<String> testProfileIds, List<String> testIds) {
        RequestOptions requestOptions = new RequestOptions();
        if (lastModifiedStartTime != null) {
            requestOptions.addQueryParam("lastModifiedStartTime", String.valueOf(lastModifiedStartTime), false);
        }
        if (lastModifiedEndTime != null) {
            requestOptions.addQueryParam("lastModifiedEndTime", String.valueOf(lastModifiedEndTime), false);
        }
        if (testProfileIds != null) {
            requestOptions.addQueryParam("testProfileIds", testProfileIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (testIds != null) {
            requestOptions.addQueryParam("testIds", testIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestProfiles(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (TestProfile)protocolMethodData.toObject(TestProfile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestServerMetricsConfiguration> createOrUpdateServerMetricsConfig(String testId, TestServerMetricsConfiguration body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateServerMetricsConfigWithResponse(testId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestServerMetricsConfiguration)protocolMethodData.toObject(TestServerMetricsConfiguration.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadTest> createOrUpdateTest(String testId, LoadTest body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getLoadTestAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateTestWithResponse(testId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTest)protocolMethodData.toObject(LoadTest.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<TestFileInfo> uploadTestFile(String testId, String fileName, BinaryData body, LoadTestingFileType fileType) {
        RequestOptions requestOptions = new RequestOptions();
        if (fileType != null) {
            requestOptions.addQueryParam("fileType", fileType.toString(), false);
        }
        return this.uploadTestFileWithResponse(testId, fileName, body, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestFileInfo)protocolMethodData.toObject(TestFileInfo.class));
    }
}

