/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.StopOnDisconnectStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class StopOnDisconnectConfiguration
implements JsonSerializable<StopOnDisconnectConfiguration> {
    private final StopOnDisconnectStatus status;
    private Integer gracePeriodInMinutes;

    private StopOnDisconnectConfiguration(StopOnDisconnectStatus status) {
        this.status = status;
    }

    public StopOnDisconnectStatus getStatus() {
        return this.status;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("gracePeriodMinutes", (Number)this.gracePeriodInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static StopOnDisconnectConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (StopOnDisconnectConfiguration)jsonReader.readObject(reader -> {
            StopOnDisconnectStatus status = null;
            Integer gracePeriodInMinutes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = StopOnDisconnectStatus.fromString(reader.getString());
                    continue;
                }
                if ("gracePeriodMinutes".equals(fieldName)) {
                    gracePeriodInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            StopOnDisconnectConfiguration deserializedStopOnDisconnectConfiguration = new StopOnDisconnectConfiguration(status);
            deserializedStopOnDisconnectConfiguration.gracePeriodInMinutes = gracePeriodInMinutes;
            return deserializedStopOnDisconnectConfiguration;
        });
    }

    public Integer getGracePeriodInMinutes() {
        return this.gracePeriodInMinutes;
    }
}

