/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.models.ResponseError;
import com.azure.developer.devcenter.models.DevBoxAction;
import com.azure.developer.devcenter.models.DevBoxActionDelayStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DevBoxActionDelayResult
implements JsonSerializable<DevBoxActionDelayResult> {
    private final String actionName;
    private DevBoxAction action;
    private ResponseError error;
    private final DevBoxActionDelayStatus delayStatus;

    private DevBoxActionDelayResult(String actionName, DevBoxActionDelayStatus delayStatus) {
        this.actionName = actionName;
        this.delayStatus = delayStatus;
    }

    public String getActionName() {
        return this.actionName;
    }

    public DevBoxAction getAction() {
        return this.action;
    }

    public ResponseError getError() {
        return this.error;
    }

    public DevBoxActionDelayStatus getDelayStatus() {
        return this.delayStatus;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.actionName);
        jsonWriter.writeStringField("result", this.delayStatus == null ? null : this.delayStatus.toString());
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static DevBoxActionDelayResult fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxActionDelayResult)jsonReader.readObject(reader -> {
            String actionName = null;
            DevBoxActionDelayStatus delayStatus = null;
            DevBoxAction action = null;
            ResponseError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    actionName = reader.getString();
                    continue;
                }
                if ("result".equals(fieldName)) {
                    delayStatus = DevBoxActionDelayStatus.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    action = DevBoxAction.fromJson(reader);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            DevBoxActionDelayResult deserializedDevBoxActionDelayResult = new DevBoxActionDelayResult(actionName, delayStatus);
            deserializedDevBoxActionDelayResult.action = action;
            deserializedDevBoxActionDelayResult.error = error;
            return deserializedDevBoxActionDelayResult;
        });
    }
}

