/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.developer.devcenter.DeploymentEnvironmentsClient;
import com.azure.developer.devcenter.DevBoxesClient;
import com.azure.developer.devcenter.DevCenterClientBuilder;
import com.azure.developer.devcenter.implementation.DeploymentEnvironmentsClientImpl;
import com.azure.developer.devcenter.implementation.DevBoxesClientImpl;
import com.azure.developer.devcenter.implementation.DevCenterClientImpl;
import com.azure.developer.devcenter.models.DevCenterProject;

@ServiceClient(builder=DevCenterClientBuilder.class)
public final class DevCenterClient {
    private final DevCenterClientImpl serviceClient;

    DevCenterClient(DevCenterClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    public DevBoxesClient getDevBoxesClient() {
        return new DevBoxesClient(new DevBoxesClientImpl(this.serviceClient.getHttpPipeline(), this.serviceClient.getSerializerAdapter(), this.serviceClient.getEndpoint(), this.serviceClient.getServiceVersion()));
    }

    public DeploymentEnvironmentsClient getDeploymentEnvironmentsClient() {
        return new DeploymentEnvironmentsClient(new DeploymentEnvironmentsClientImpl(this.serviceClient.getHttpPipeline(), this.serviceClient.getSerializerAdapter(), this.serviceClient.getEndpoint(), this.serviceClient.getServiceVersion()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listProjects(RequestOptions requestOptions) {
        return this.serviceClient.listProjects(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getProjectWithResponse(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.getProjectWithResponse(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevCenterProject> listProjects() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listProjects(requestOptions).mapPage(bodyItemValue -> (DevCenterProject)bodyItemValue.toObject(DevCenterProject.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevCenterProject getProject(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevCenterProject)((BinaryData)this.getProjectWithResponse(projectName, requestOptions).getValue()).toObject(DevCenterProject.class);
    }
}

