/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.devcenter.DevBoxesClientBuilder;
import com.azure.developer.devcenter.implementation.DevBoxesClientImpl;
import com.azure.developer.devcenter.models.DevBox;
import com.azure.developer.devcenter.models.DevBoxAction;
import com.azure.developer.devcenter.models.DevBoxActionDelayResult;
import com.azure.developer.devcenter.models.DevBoxPool;
import com.azure.developer.devcenter.models.DevBoxSchedule;
import com.azure.developer.devcenter.models.DevCenterOperationDetails;
import com.azure.developer.devcenter.models.RemoteConnection;
import java.time.OffsetDateTime;

@ServiceClient(builder=DevBoxesClientBuilder.class)
public final class DevBoxesClient {
    private final DevBoxesClientImpl serviceClient;

    DevBoxesClient(DevBoxesClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPools(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listPools(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getPoolWithResponse(String projectName, String poolName, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponse(projectName, poolName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSchedules(String projectName, String poolName, RequestOptions requestOptions) {
        return this.serviceClient.listSchedules(projectName, poolName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getScheduleWithResponse(String projectName, String poolName, String scheduleName, RequestOptions requestOptions) {
        return this.serviceClient.getScheduleWithResponse(projectName, poolName, scheduleName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAllDevBoxes(RequestOptions requestOptions) {
        return this.serviceClient.listAllDevBoxes(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAllDevBoxesByUser(String userId, RequestOptions requestOptions) {
        return this.serviceClient.listAllDevBoxesByUser(userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevBoxes(String projectName, String userId, RequestOptions requestOptions) {
        return this.serviceClient.listDevBoxes(projectName, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.getDevBoxWithResponse(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCreateDevBox(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.beginCreateDevBox(projectName, userId, devBoxName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, Void> beginDeleteDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteDevBox(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginStartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginStartDevBox(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginStopDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginStopDevBox(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginRestartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginRestartDevBox(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRemoteConnectionWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.getRemoteConnectionWithResponse(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevBoxActions(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.listDevBoxActions(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDevBoxActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        return this.serviceClient.getDevBoxActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> skipActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        return this.serviceClient.skipActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> delayActionWithResponse(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        return this.serviceClient.delayActionWithResponse(projectName, userId, devBoxName, actionName, delayUntil, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> delayAllActions(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        return this.serviceClient.delayAllActions(projectName, userId, devBoxName, delayUntil, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBoxPool> listPools(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listPools(projectName, requestOptions).mapPage(bodyItemValue -> (DevBoxPool)bodyItemValue.toObject(DevBoxPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevBoxPool getPool(String projectName, String poolName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevBoxPool)((BinaryData)this.getPoolWithResponse(projectName, poolName, requestOptions).getValue()).toObject(DevBoxPool.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBoxSchedule> listSchedules(String projectName, String poolName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listSchedules(projectName, poolName, requestOptions).mapPage(bodyItemValue -> (DevBoxSchedule)bodyItemValue.toObject(DevBoxSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevBoxSchedule getSchedule(String projectName, String poolName, String scheduleName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevBoxSchedule)((BinaryData)this.getScheduleWithResponse(projectName, poolName, scheduleName, requestOptions).getValue()).toObject(DevBoxSchedule.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBox> listAllDevBoxes() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listAllDevBoxes(requestOptions).mapPage(bodyItemValue -> (DevBox)bodyItemValue.toObject(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBox> listAllDevBoxesByUser(String userId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listAllDevBoxesByUser(userId, requestOptions).mapPage(bodyItemValue -> (DevBox)bodyItemValue.toObject(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBox> listDevBoxes(String projectName, String userId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listDevBoxes(projectName, userId, requestOptions).mapPage(bodyItemValue -> (DevBox)bodyItemValue.toObject(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevBox getDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevBox)((BinaryData)this.getDevBoxWithResponse(projectName, userId, devBoxName, requestOptions).getValue()).toObject(DevBox.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, DevBox> beginCreateDevBox(String projectName, String userId, DevBox devBox) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCreateDevBoxWithModel(projectName, userId, devBox.getName(), BinaryData.fromObject((Object)devBox), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginDeleteDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginDeleteDevBoxWithModel(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginStartDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginStartDevBoxWithModel(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginStopDevBox(String projectName, String userId, String devBoxName, Boolean hibernate) {
        RequestOptions requestOptions = new RequestOptions();
        if (hibernate != null) {
            requestOptions.addQueryParam("hibernate", String.valueOf(hibernate), false);
        }
        return this.serviceClient.beginStopDevBoxWithModel(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginStopDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginStopDevBoxWithModel(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginRestartDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginRestartDevBoxWithModel(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoteConnection getRemoteConnection(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return (RemoteConnection)((BinaryData)this.getRemoteConnectionWithResponse(projectName, userId, devBoxName, requestOptions).getValue()).toObject(RemoteConnection.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBoxAction> listDevBoxActions(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listDevBoxActions(projectName, userId, devBoxName, requestOptions).mapPage(bodyItemValue -> (DevBoxAction)bodyItemValue.toObject(DevBoxAction.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevBoxAction getDevBoxAction(String projectName, String userId, String devBoxName, String actionName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevBoxAction)((BinaryData)this.getDevBoxActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions).getValue()).toObject(DevBoxAction.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void skipAction(String projectName, String userId, String devBoxName, String actionName) {
        RequestOptions requestOptions = new RequestOptions();
        this.skipActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevBoxAction delayAction(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevBoxAction)((BinaryData)this.delayActionWithResponse(projectName, userId, devBoxName, actionName, delayUntil, requestOptions).getValue()).toObject(DevBoxAction.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevBoxActionDelayResult> delayAllActions(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.delayAllActions(projectName, userId, devBoxName, delayUntil, requestOptions).mapPage(bodyItemValue -> (DevBoxActionDelayResult)bodyItemValue.toObject(DevBoxActionDelayResult.class));
    }
}

