/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.EnvironmentTypeStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DevCenterEnvironmentType
implements JsonSerializable<DevCenterEnvironmentType> {
    private String name;
    private final String deploymentTargetId;
    private final EnvironmentTypeStatus status;

    public String getName() {
        return this.name;
    }

    public String getDeploymentTargetId() {
        return this.deploymentTargetId;
    }

    public EnvironmentTypeStatus getStatus() {
        return this.status;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deploymentTargetId", this.deploymentTargetId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static DevCenterEnvironmentType fromJson(JsonReader jsonReader) throws IOException {
        return (DevCenterEnvironmentType)jsonReader.readObject(reader -> {
            String name = null;
            String deploymentTargetId = null;
            EnvironmentTypeStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("deploymentTargetId".equals(fieldName)) {
                    deploymentTargetId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = EnvironmentTypeStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DevCenterEnvironmentType deserializedDevCenterEnvironmentType = new DevCenterEnvironmentType(deploymentTargetId, status);
            deserializedDevCenterEnvironmentType.name = name;
            return deserializedDevCenterEnvironmentType;
        });
    }

    private DevCenterEnvironmentType(String deploymentTargetId, EnvironmentTypeStatus status) {
        this.deploymentTargetId = deploymentTargetId;
        this.status = status;
    }
}

