/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DevBoxImageReference
implements JsonSerializable<DevBoxImageReference> {
    private String name;
    private String version;
    private String operatingSystem;
    private String osBuildNumber;
    private OffsetDateTime publishedDate;

    private DevBoxImageReference() {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOsBuildNumber() {
        return this.osBuildNumber;
    }

    public OffsetDateTime getPublishedDate() {
        return this.publishedDate;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DevBoxImageReference fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxImageReference)jsonReader.readObject(reader -> {
            DevBoxImageReference deserializedDevBoxImageReference = new DevBoxImageReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDevBoxImageReference.name = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDevBoxImageReference.version = reader.getString();
                    continue;
                }
                if ("operatingSystem".equals(fieldName)) {
                    deserializedDevBoxImageReference.operatingSystem = reader.getString();
                    continue;
                }
                if ("osBuildNumber".equals(fieldName)) {
                    deserializedDevBoxImageReference.osBuildNumber = reader.getString();
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedDevBoxImageReference.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDevBoxImageReference;
        });
    }
}

