/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.EnvironmentDefinitionParameter;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EnvironmentDefinition
implements JsonSerializable<EnvironmentDefinition> {
    private final String id;
    private String name;
    private final String catalogName;
    private String description;
    private List<EnvironmentDefinitionParameter> parameters;
    private String parametersSchema;
    private String templatePath;

    private EnvironmentDefinition(String id, String catalogName) {
        this.id = id;
        this.catalogName = catalogName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EnvironmentDefinitionParameter> getParameters() {
        return this.parameters;
    }

    public String getParametersSchema() {
        return this.parametersSchema;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("catalogName", this.catalogName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("parametersSchema", this.parametersSchema);
        jsonWriter.writeStringField("templatePath", this.templatePath);
        return jsonWriter.writeEndObject();
    }

    public static EnvironmentDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (EnvironmentDefinition)jsonReader.readObject(reader -> {
            String id = null;
            String name = null;
            String catalogName = null;
            String description = null;
            List parameters = null;
            String parametersSchema = null;
            String templatePath = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("catalogName".equals(fieldName)) {
                    catalogName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = reader.readArray(reader1 -> EnvironmentDefinitionParameter.fromJson(reader1));
                    continue;
                }
                if ("parametersSchema".equals(fieldName)) {
                    parametersSchema = reader.getString();
                    continue;
                }
                if ("templatePath".equals(fieldName)) {
                    templatePath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            EnvironmentDefinition deserializedEnvironmentDefinition = new EnvironmentDefinition(id, catalogName);
            deserializedEnvironmentDefinition.name = name;
            deserializedEnvironmentDefinition.description = description;
            deserializedEnvironmentDefinition.parameters = parameters;
            deserializedEnvironmentDefinition.parametersSchema = parametersSchema;
            deserializedEnvironmentDefinition.templatePath = templatePath;
            return deserializedEnvironmentDefinition;
        });
    }
}

