/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.implementation.models.RetentionPolicy;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class Metrics
implements XmlSerializable<Metrics> {
    private String version;
    private boolean enabled;
    private Boolean includeAPIs;
    private RetentionPolicy retentionPolicy;

    public String getVersion() {
        return this.version;
    }

    public Metrics setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Metrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isIncludeAPIs() {
        return this.includeAPIs;
    }

    public Metrics setIncludeAPIs(Boolean includeAPIs) {
        this.includeAPIs = includeAPIs;
        return this;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public Metrics setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Metrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeAPIs);
        xmlWriter.writeXml((XmlSerializable)this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    public static Metrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return Metrics.fromXml(xmlReader, null);
    }

    public static Metrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Metrics" : rootElementName;
        return (Metrics)xmlReader.readObject(finalRootElementName, reader -> {
            Metrics deserializedMetrics = new Metrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedMetrics.version = reader.getStringElement();
                    continue;
                }
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedMetrics.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedMetrics.includeAPIs = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedMetrics.retentionPolicy = RetentionPolicy.fromXml(reader, "RetentionPolicy");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedMetrics;
        });
    }
}

