// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Azure Analytics Logging settings.
 */
@Fluent
public final class Logging implements XmlSerializable<Logging> {
    /*
     * The version of Analytics to configure.
     */
    private String version;

    /*
     * Indicates whether all delete requests should be logged.
     */
    private boolean delete;

    /*
     * Indicates whether all read requests should be logged.
     */
    private boolean read;

    /*
     * Indicates whether all write requests should be logged.
     */
    private boolean write;

    /*
     * The retention policy.
     */
    private RetentionPolicy retentionPolicy;

    /**
     * Creates an instance of Logging class.
     */
    public Logging() {
    }

    /**
     * Get the version property: The version of Analytics to configure.
     * 
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of Analytics to configure.
     * 
     * @param version the version value to set.
     * @return the Logging object itself.
     */
    public Logging setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the delete property: Indicates whether all delete requests should be logged.
     * 
     * @return the delete value.
     */
    public boolean isDelete() {
        return this.delete;
    }

    /**
     * Set the delete property: Indicates whether all delete requests should be logged.
     * 
     * @param delete the delete value to set.
     * @return the Logging object itself.
     */
    public Logging setDelete(boolean delete) {
        this.delete = delete;
        return this;
    }

    /**
     * Get the read property: Indicates whether all read requests should be logged.
     * 
     * @return the read value.
     */
    public boolean isRead() {
        return this.read;
    }

    /**
     * Set the read property: Indicates whether all read requests should be logged.
     * 
     * @param read the read value to set.
     * @return the Logging object itself.
     */
    public Logging setRead(boolean read) {
        this.read = read;
        return this;
    }

    /**
     * Get the write property: Indicates whether all write requests should be logged.
     * 
     * @return the write value.
     */
    public boolean isWrite() {
        return this.write;
    }

    /**
     * Set the write property: Indicates whether all write requests should be logged.
     * 
     * @param write the write value to set.
     * @return the Logging object itself.
     */
    public Logging setWrite(boolean write) {
        this.write = write;
        return this;
    }

    /**
     * Get the retentionPolicy property: The retention policy.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: The retention policy.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the Logging object itself.
     */
    public Logging setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Logging" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Delete", this.delete);
        xmlWriter.writeBooleanElement("Read", this.read);
        xmlWriter.writeBooleanElement("Write", this.write);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of Logging from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of Logging if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the Logging.
     */
    public static Logging fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of Logging from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of Logging if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the Logging.
     */
    public static Logging fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Logging" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            Logging deserializedLogging = new Logging();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedLogging.version = reader.getStringElement();
                } else if ("Delete".equals(elementName.getLocalPart())) {
                    deserializedLogging.delete = reader.getBooleanElement();
                } else if ("Read".equals(elementName.getLocalPart())) {
                    deserializedLogging.read = reader.getBooleanElement();
                } else if ("Write".equals(elementName.getLocalPart())) {
                    deserializedLogging.write = reader.getBooleanElement();
                } else if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedLogging.retentionPolicy = RetentionPolicy.fromXml(reader, "RetentionPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedLogging;
        });
    }
}
