/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.TableEntityAccessHelper;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class TableEntity {
    private final ClientLogger logger = new ClientLogger(TableEntity.class);
    private final Map<String, Object> properties;
    private final String partitionKey;
    private final String rowKey;

    public TableEntity(String partitionKey, String rowKey) {
        if (null == partitionKey) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' is an null value.", "PartitionKey")));
        }
        if (null == rowKey) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' is an null value.", "RowKey")));
        }
        this.properties = new HashMap<String, Object>();
        this.properties.put("PartitionKey", partitionKey);
        this.properties.put("RowKey", rowKey);
        this.partitionKey = partitionKey;
        this.rowKey = rowKey;
    }

    private TableEntity() {
        this.properties = new HashMap<String, Object>();
        this.partitionKey = null;
        this.rowKey = null;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public TableEntity addProperty(String key, Object value) {
        this.validateProperty(key, value);
        this.properties.put(key, value);
        return this;
    }

    public TableEntity setProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.validateProperty(entry.getKey(), entry.getValue());
        }
        this.properties.clear();
        if (this.partitionKey != null) {
            this.properties.put("PartitionKey", this.partitionKey);
        }
        if (this.rowKey != null) {
            this.properties.put("RowKey", this.rowKey);
        }
        this.properties.putAll(properties);
        return this;
    }

    private void validateProperty(String key, Object value) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if ("Timestamp".equals(key) && value != null && !(value instanceof OffsetDateTime)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' must be an OffsetDateTime.", key)));
        }
        if (("odata.etag".equals(key) || "odata.editLink".equals(key) || "odata.id".equals(key) || "odata.type".equals(key)) && value != null && !(value instanceof String)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' must be a String.", key)));
        }
    }

    public String getRowKey() {
        return (String)this.properties.get("RowKey");
    }

    public String getPartitionKey() {
        return (String)this.properties.get("PartitionKey");
    }

    public OffsetDateTime getTimestamp() {
        return (OffsetDateTime)this.properties.get("Timestamp");
    }

    public String getETag() {
        return (String)this.properties.get("odata.etag");
    }

    String getOdataType() {
        return (String)this.properties.get("odata.type");
    }

    String getOdataId() {
        return (String)this.properties.get("odata.id");
    }

    String getOdataEditLink() {
        return (String)this.properties.get("odata.editLink");
    }

    static {
        TableEntityAccessHelper.setTableEntityCreator(TableEntity::new);
    }
}

