/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableEntityUpdateMode;
import reactor.core.publisher.Mono;

public interface TransactionalBatchAction {
    public Mono<HttpRequest> prepareRequest(TableAsyncClient var1);

    public HttpRequest prepareRequest(TableClient var1);

    public static class DeleteEntity
    implements TransactionalBatchAction {
        private final TableEntity entity;
        private final boolean ifUnchanged;

        public DeleteEntity(TableEntity entity, boolean ifUnchanged) {
            this.entity = entity;
            this.ifUnchanged = ifUnchanged;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        public boolean getIfUnchanged() {
            return this.ifUnchanged;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.deleteEntityWithResponse(this.entity, this.ifUnchanged).map(Response::getRequest);
        }

        @Override
        public HttpRequest prepareRequest(TableClient preparer) {
            return preparer.deleteEntityWithResponse(this.entity, this.ifUnchanged, null, null).getRequest();
        }

        public String toString() {
            return "DeleteEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + ", eTag='" + this.entity.getETag() + '\'' + ", ifUnchanged=" + this.ifUnchanged + '}';
        }
    }

    public static class UpdateEntity
    implements TransactionalBatchAction {
        private final TableEntity entity;
        private final TableEntityUpdateMode updateMode;
        private final boolean ifUnchanged;

        public UpdateEntity(TableEntity entity, TableEntityUpdateMode updateMode, boolean ifUnchanged) {
            this.entity = entity;
            this.updateMode = updateMode;
            this.ifUnchanged = ifUnchanged;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        public TableEntityUpdateMode getUpdateMode() {
            return this.updateMode;
        }

        public boolean getIfUnchanged() {
            return this.ifUnchanged;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.updateEntityWithResponse(this.entity, this.updateMode, this.ifUnchanged).map(Response::getRequest);
        }

        @Override
        public HttpRequest prepareRequest(TableClient preparer) {
            return preparer.updateEntityWithResponse(this.entity, this.updateMode, this.ifUnchanged, null, null).getRequest();
        }

        public String toString() {
            return "UpdateEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + ", updateMode=" + (Object)((Object)this.updateMode) + ", ifUnchanged=" + this.ifUnchanged + '}';
        }
    }

    public static class UpsertEntity
    implements TransactionalBatchAction {
        private final TableEntity entity;
        private final TableEntityUpdateMode updateMode;

        public UpsertEntity(TableEntity entity, TableEntityUpdateMode updateMode) {
            this.entity = entity;
            this.updateMode = updateMode;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        public TableEntityUpdateMode getUpdateMode() {
            return this.updateMode;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.upsertEntityWithResponse(this.entity, this.updateMode).map(Response::getRequest);
        }

        @Override
        public HttpRequest prepareRequest(TableClient preparer) {
            return preparer.upsertEntityWithResponse(this.entity, this.updateMode, null, null).getRequest();
        }

        public String toString() {
            return "UpsertEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + ", updateMode=" + (Object)((Object)this.updateMode) + '}';
        }
    }

    public static class CreateEntity
    implements TransactionalBatchAction {
        private final TableEntity entity;

        public CreateEntity(TableEntity entity) {
            this.entity = entity;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient client) {
            return client.createEntityWithResponse(this.entity).map(Response::getRequest);
        }

        @Override
        public HttpRequest prepareRequest(TableClient client) {
            return client.createEntityWithResponse(this.entity, null, null).getRequest();
        }

        public String toString() {
            return "CreateEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + '}';
        }
    }
}

