// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The response for a single table.
 */
@Fluent
public final class TableResponse extends TableResponseProperties {
    /*
     * The metadata response of the table.
     */
    private String odataMetadata;

    /**
     * Creates an instance of TableResponse class.
     */
    public TableResponse() {
    }

    /**
     * Get the odataMetadata property: The metadata response of the table.
     * 
     * @return the odataMetadata value.
     */
    public String getOdataMetadata() {
        return this.odataMetadata;
    }

    /**
     * Set the odataMetadata property: The metadata response of the table.
     * 
     * @param odataMetadata the odataMetadata value to set.
     * @return the TableResponse object itself.
     */
    public TableResponse setOdataMetadata(String odataMetadata) {
        this.odataMetadata = odataMetadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableResponse setTableName(String tableName) {
        super.setTableName(tableName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableResponse setOdataType(String odataType) {
        super.setOdataType(odataType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableResponse setOdataId(String odataId) {
        super.setOdataId(odataId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableResponse setOdataEditLink(String odataEditLink) {
        super.setOdataEditLink(odataEditLink);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("TableName", getTableName());
        jsonWriter.writeStringField("odata.type", getOdataType());
        jsonWriter.writeStringField("odata.id", getOdataId());
        jsonWriter.writeStringField("odata.editLink", getOdataEditLink());
        jsonWriter.writeStringField("odata.metadata", this.odataMetadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableResponse if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TableResponse.
     */
    public static TableResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableResponse deserializedTableResponse = new TableResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("TableName".equals(fieldName)) {
                    deserializedTableResponse.setTableName(reader.getString());
                } else if ("odata.type".equals(fieldName)) {
                    deserializedTableResponse.setOdataType(reader.getString());
                } else if ("odata.id".equals(fieldName)) {
                    deserializedTableResponse.setOdataId(reader.getString());
                } else if ("odata.editLink".equals(fieldName)) {
                    deserializedTableResponse.setOdataEditLink(reader.getString());
                } else if ("odata.metadata".equals(fieldName)) {
                    deserializedTableResponse.odataMetadata = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableResponse;
        });
    }
}
