/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.data.appconfiguration.implementation.ConfigurationSettingHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ConfigurationSetting
implements JsonSerializable<ConfigurationSetting> {
    public static final String NO_LABEL = "\u0000";
    private String key;
    private String label;
    private String value;
    private String contentType;
    private String etag;
    private OffsetDateTime lastModified;
    private boolean readOnly;
    private Map<String, String> tags;

    public String getKey() {
        return this.key;
    }

    public ConfigurationSetting setKey(String key) {
        this.key = key;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public ConfigurationSetting setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ConfigurationSetting setValue(String value) {
        this.value = value;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ConfigurationSetting setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getETag() {
        return this.etag;
    }

    public ConfigurationSetting setETag(String etag) {
        this.etag = etag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    private ConfigurationSetting setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private ConfigurationSetting setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags == null ? Collections.emptyMap() : this.tags;
    }

    public ConfigurationSetting setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String toString() {
        return String.format("ConfigurationSetting(key=%s, label=%s, value=%s, etag=%s)", this.key, this.label, this.value, this.etag);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("content_type", this.contentType);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("last_modified", Objects.toString(this.lastModified, null));
        jsonWriter.writeBooleanField("locked", this.readOnly);
        jsonWriter.writeMapField("tags", this.tags, JsonWriter::writeString);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationSetting fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationSetting)jsonReader.readObject(reader -> {
            ConfigurationSetting setting = new ConfigurationSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonReader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    setting.setKey(reader.getString());
                    continue;
                }
                if ("label".equals(fieldName)) {
                    setting.setLabel(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    setting.setKey(reader.getString());
                    continue;
                }
                if ("content_type".equals(fieldName)) {
                    setting.setContentType(reader.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    setting.setETag(reader.getString());
                    continue;
                }
                if ("last_modified".equals(fieldName)) {
                    setting.setLastModified((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("locked".equals(fieldName)) {
                    setting.setReadOnly(reader.getBoolean());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    setting.setTags(reader.readMap(JsonReader::getString));
                    continue;
                }
                reader.skipChildren();
            }
            return setting;
        });
    }

    static {
        ConfigurationSettingHelper.setAccessor(new ConfigurationSettingHelper.ConfigurationSettingAccessor(){

            @Override
            public ConfigurationSetting setReadOnly(ConfigurationSetting setting, boolean readOnly) {
                return setting.setReadOnly(readOnly);
            }

            @Override
            public ConfigurationSetting setLastModified(ConfigurationSetting setting, OffsetDateTime lastModified) {
                return setting.setLastModified(lastModified);
            }
        });
    }
}

