/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.appconfiguration.models.SettingFields;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class SettingSelector {
    private String keyFilter;
    private String labelFilter;
    private SettingFields[] fields;
    private String acceptDatetime;

    public String getKeyFilter() {
        return this.keyFilter;
    }

    public SettingSelector setKeyFilter(String keyFilter) {
        this.keyFilter = keyFilter;
        return this;
    }

    public String getLabelFilter() {
        return this.labelFilter;
    }

    public SettingSelector setLabelFilter(String labelFilter) {
        this.labelFilter = labelFilter;
        return this;
    }

    public String getAcceptDateTime() {
        return this.acceptDatetime;
    }

    public SettingSelector setAcceptDatetime(OffsetDateTime datetime) {
        this.acceptDatetime = datetime == null ? null : DateTimeFormatter.RFC_1123_DATE_TIME.toFormat().format(datetime);
        return this;
    }

    public SettingFields[] getFields() {
        return this.fields == null ? new SettingFields[]{} : (SettingFields[])CoreUtils.clone((Object[])this.fields);
    }

    public SettingSelector setFields(SettingFields ... fields) {
        this.fields = fields;
        return this;
    }

    public String toString() {
        String fields = CoreUtils.isNullOrEmpty((Object[])this.fields) ? "ALL_FIELDS" : CoreUtils.arrayToString((Object[])this.fields, SettingFields::toStringMapper);
        return String.format("SettingSelector(keyFilter=%s, labelFilter=%s, acceptDateTime=%s, fields=%s)", this.keyFilter, this.labelFilter, this.acceptDatetime, fields);
    }
}

