/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.SyncToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class SyncTokenPolicy
implements HttpPipelinePolicy {
    private static final String COMMA = ",";
    private static final String EQUAL = "=";
    private static final String SYNC_TOKEN = "Sync-Token";
    private static final String SKIP_INVALID_TOKEN = "Skipping invalid sync token '{}'.";
    private final Map<String, SyncToken> syncTokenMap = new ConcurrentHashMap<String, SyncToken>();
    private final ClientLogger logger = new ClientLogger(SyncTokenPolicy.class);

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        context.getHttpRequest().setHeader(SYNC_TOKEN, this.getSyncTokenHeader());
        return next.process().flatMap(httpResponse -> {
            String syncTokenValue = httpResponse.getHeaders().getValue(SYNC_TOKEN);
            if (syncTokenValue != null) {
                this.updateSyncToken(syncTokenValue);
            }
            return Mono.just((Object)httpResponse);
        });
    }

    private String getSyncTokenHeader() {
        return this.syncTokenMap.values().stream().map(syncToken -> syncToken.getId() + EQUAL + syncToken.getValue()).collect(Collectors.joining(COMMA));
    }

    public void updateSyncToken(String token) {
        String[] syncTokens;
        for (String syncTokenString : syncTokens = token.split(COMMA)) {
            SyncToken syncToken;
            if (CoreUtils.isNullOrEmpty((CharSequence)syncTokenString)) continue;
            try {
                syncToken = SyncToken.createSyncToken(syncTokenString);
            }
            catch (Exception ex) {
                this.logger.info(SKIP_INVALID_TOKEN, new Object[]{syncTokenString});
                continue;
            }
            String tokenId = syncToken.getId();
            this.syncTokenMap.compute(tokenId, (key, existingSyncToken) -> {
                if (existingSyncToken == null || syncToken.getSequenceNumber() > existingSyncToken.getSequenceNumber()) {
                    return syncToken;
                }
                return existingSyncToken;
            });
        }
    }
}

