/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.ConfigurationService;
import com.azure.data.appconfiguration.ConfigurationServiceVersion;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonDeserializer;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonSerializer;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingFields;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.fasterxml.jackson.databind.Module;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ConfigurationClientBuilder.class, isAsync=true, serviceInterfaces={ConfigurationService.class})
public final class ConfigurationAsyncClient {
    private final ClientLogger logger = new ClientLogger(ConfigurationAsyncClient.class);
    private static final String APP_CONFIG_TRACING_NAMESPACE_VALUE = "Microsoft.AppConfiguration";
    private static final String ETAG_ANY = "*";
    private final String serviceEndpoint;
    private final ConfigurationService service;
    private final String apiVersion;
    private final SyncTokenPolicy syncTokenPolicy;

    ConfigurationAsyncClient(String serviceEndpoint, HttpPipeline pipeline, ConfigurationServiceVersion version, SyncTokenPolicy syncTokenPolicy) {
        JacksonAdapter jacksonAdapter = new JacksonAdapter();
        jacksonAdapter.serializer().registerModule((Module)ConfigurationSettingJsonSerializer.getModule());
        jacksonAdapter.serializer().registerModule((Module)ConfigurationSettingJsonDeserializer.getModule());
        this.service = (ConfigurationService)RestProxy.create(ConfigurationService.class, (HttpPipeline)pipeline, (SerializerAdapter)jacksonAdapter);
        this.serviceEndpoint = serviceEndpoint;
        this.apiVersion = version.getVersion();
        this.syncTokenPolicy = syncTokenPolicy;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(String key, String label, String value) {
        try {
            return FluxUtil.withContext(context -> this.addConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), (Context)context)).flatMap(response -> Mono.justOrEmpty((Object)((ConfigurationSetting)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> addConfigurationSetting(ConfigurationSetting setting) {
        return this.addConfigurationSettingWithResponse(setting).map(response -> (ConfigurationSetting)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> addConfigurationSettingWithResponse(ConfigurationSetting setting) {
        try {
            return FluxUtil.withContext(context -> this.addConfigurationSetting(setting, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ConfigurationSetting>> addConfigurationSetting(ConfigurationSetting setting, Context context) {
        ConfigurationAsyncClient.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        return this.service.setKey(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, setting, null, ConfigurationAsyncClient.getETagValue(ETAG_ANY), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).onErrorResume(HttpResponseException.class, throwable -> {
            HttpResponseException e = (HttpResponseException)throwable;
            HttpResponse httpResponse = e.getResponse();
            if (httpResponse.getStatusCode() == 412) {
                return Mono.error((Throwable)new ResourceExistsException("Setting was already present.", httpResponse, throwable));
            }
            return Mono.error((Throwable)throwable);
        }).doOnSubscribe(ignoredValue -> this.logger.info("Adding ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Added ConfigurationSetting - {}", new Object[]{response.getValue()})).onErrorMap(ConfigurationAsyncClient::addConfigurationSettingExceptionMapper).doOnError(error -> this.logger.warning("Failed to add ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(String key, String label, String value) {
        try {
            return FluxUtil.withContext(context -> this.setConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label).setValue(value), false, (Context)context)).flatMap(response -> Mono.justOrEmpty((Object)((ConfigurationSetting)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setConfigurationSetting(ConfigurationSetting setting) {
        return this.setConfigurationSettingWithResponse(setting, false).map(response -> (ConfigurationSetting)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        try {
            return FluxUtil.withContext(context -> this.setConfigurationSetting(setting, ifUnchanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ConfigurationSetting>> setConfigurationSetting(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        ConfigurationAsyncClient.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? ConfigurationAsyncClient.getETagValue(setting.getETag()) : null;
        return this.service.setKey(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, setting, ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Setting ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Set ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to set ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label) {
        try {
            return this.getConfigurationSetting(key, label, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(String key, String label, OffsetDateTime acceptDateTime) {
        try {
            return FluxUtil.withContext(context -> this.getConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label), acceptDateTime, false, (Context)context)).flatMap(response -> Mono.justOrEmpty((Object)((ConfigurationSetting)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> getConfigurationSetting(ConfigurationSetting setting) {
        return this.getConfigurationSettingWithResponse(setting, null, false).map(response -> (ConfigurationSetting)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> getConfigurationSettingWithResponse(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean ifChanged) {
        try {
            return FluxUtil.withContext(context -> this.getConfigurationSetting(setting, acceptDateTime, ifChanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ConfigurationSetting>> getConfigurationSetting(ConfigurationSetting setting, OffsetDateTime acceptDateTime, boolean onlyIfChanged, Context context) {
        ConfigurationAsyncClient.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifNoneMatchETag = onlyIfChanged ? ConfigurationAsyncClient.getETagValue(setting.getETag()) : null;
        return this.service.getKeyValue(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, null, acceptDateTime == null ? null : acceptDateTime.toString(), null, ifNoneMatchETag, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).onErrorResume(HttpResponseException.class, throwable -> {
            HttpResponseException e = (HttpResponseException)throwable;
            HttpResponse httpResponse = e.getResponse();
            if (httpResponse.getStatusCode() == 304) {
                return Mono.just((Object)new ResponseBase(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null, null));
            }
            if (httpResponse.getStatusCode() == 404) {
                return Mono.error((Throwable)new ResourceNotFoundException("Setting not found.", httpResponse, throwable));
            }
            return Mono.error((Throwable)throwable);
        }).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Retrieved ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to get ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(String key, String label) {
        try {
            return FluxUtil.withContext(context -> this.deleteConfigurationSetting(new ConfigurationSetting().setKey(key).setLabel(label), false, (Context)context)).flatMap(response -> Mono.justOrEmpty((Object)((ConfigurationSetting)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> deleteConfigurationSetting(ConfigurationSetting setting) {
        return this.deleteConfigurationSettingWithResponse(setting, false).map(response -> (ConfigurationSetting)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> deleteConfigurationSettingWithResponse(ConfigurationSetting setting, boolean ifUnchanged) {
        try {
            return FluxUtil.withContext(context -> this.deleteConfigurationSetting(setting, ifUnchanged, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ConfigurationSetting>> deleteConfigurationSetting(ConfigurationSetting setting, boolean ifUnchanged, Context context) {
        ConfigurationAsyncClient.validateSetting(setting);
        context = context == null ? Context.NONE : context;
        String ifMatchETag = ifUnchanged ? ConfigurationAsyncClient.getETagValue(setting.getETag()) : null;
        return this.service.delete(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, ifMatchETag, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Deleting ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Deleted ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to delete ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(String key, String label, boolean isReadOnly) {
        try {
            return FluxUtil.withContext(context -> this.setReadOnly(new ConfigurationSetting().setKey(key).setLabel(label), isReadOnly, (Context)context)).flatMap(response -> Mono.justOrEmpty((Object)((ConfigurationSetting)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationSetting> setReadOnly(ConfigurationSetting setting, boolean isReadOnly) {
        return this.setReadOnlyWithResponse(setting, isReadOnly).map(response -> (ConfigurationSetting)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationSetting>> setReadOnlyWithResponse(ConfigurationSetting setting, boolean isReadOnly) {
        try {
            return FluxUtil.withContext(context -> this.setReadOnly(setting, isReadOnly, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ConfigurationSetting>> setReadOnly(ConfigurationSetting setting, boolean isReadOnly, Context context) {
        ConfigurationAsyncClient.validateSetting(setting);
        Context context2 = context = context == null ? Context.NONE : context;
        if (isReadOnly) {
            return this.service.lockKeyValue(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.verbose("Setting read only ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Set read only ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to set read only ConfigurationSetting - {}", new Object[]{setting, error}));
        }
        return this.service.unlockKeyValue(this.serviceEndpoint, setting.getKey(), setting.getLabel(), this.apiVersion, null, null, context).doOnSubscribe(ignoredValue -> this.logger.verbose("Clearing read only ConfigurationSetting - {}", new Object[]{setting})).doOnSuccess(response -> this.logger.info("Cleared read only ConfigurationSetting - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to clear read only ConfigurationSetting - {}", new Object[]{setting, error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listConfigurationSettings(SettingSelector selector) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listFirstPageSettings(selector, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listNextPageSettings((Context)context, (String)continuationToken)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<ConfigurationSetting> listConfigurationSettings(SettingSelector selector, Context context) {
        return new PagedFlux(() -> this.listFirstPageSettings(selector, context), continuationToken -> this.listNextPageSettings(context, (String)continuationToken));
    }

    private Mono<PagedResponse<ConfigurationSetting>> listNextPageSettings(Context context, String continuationToken) {
        try {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return Mono.empty();
            }
            return this.service.listKeyValues(this.serviceEndpoint, continuationToken, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<ConfigurationSetting>> listFirstPageSettings(SettingSelector selector, Context context) {
        try {
            if (selector == null) {
                return this.service.listKeyValues(this.serviceEndpoint, null, null, this.apiVersion, null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing all ConfigurationSettings")).doOnSuccess(response -> this.logger.info("Listed all ConfigurationSettings")).doOnError(error -> this.logger.warning("Failed to list all ConfigurationSetting", new Object[]{error}));
            }
            String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
            String keyFilter = selector.getKeyFilter();
            String labelFilter = selector.getLabelFilter();
            return this.service.listKeyValues(this.serviceEndpoint, keyFilter, labelFilter, this.apiVersion, fields, selector.getAcceptDateTime(), context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Listing ConfigurationSettings - {}", new Object[]{selector})).doOnSuccess(response -> this.logger.info("Listed ConfigurationSettings - {}", new Object[]{selector})).doOnError(error -> this.logger.warning("Failed to list ConfigurationSetting - {}", new Object[]{selector, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationSetting> listRevisions(SettingSelector selector) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRevisionsFirstPage(selector, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRevisionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    Mono<PagedResponse<ConfigurationSetting>> listRevisionsFirstPage(SettingSelector selector, Context context) {
        try {
            Mono result;
            if (selector != null) {
                String fields = CoreUtils.arrayToString((Object[])selector.getFields(), SettingFields::toStringMapper);
                String keyFilter = selector.getKeyFilter();
                String labelFilter = selector.getLabelFilter();
                result = this.service.listKeyValueRevisions(this.serviceEndpoint, keyFilter, labelFilter, this.apiVersion, fields, selector.getAcceptDateTime(), null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing ConfigurationSetting revisions - {}", new Object[]{selector})).doOnSuccess(response -> this.logger.info("Listed ConfigurationSetting revisions - {}", new Object[]{selector})).doOnError(error -> this.logger.warning("Failed to list ConfigurationSetting revisions - {}", new Object[]{selector, error}));
            } else {
                result = this.service.listKeyValueRevisions(this.serviceEndpoint, null, null, this.apiVersion, null, null, null, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnRequest(ignoredValue -> this.logger.info("Listing ConfigurationSetting revisions")).doOnSuccess(response -> this.logger.info("Listed ConfigurationSetting revisions")).doOnError(error -> this.logger.warning("Failed to list all ConfigurationSetting revisions", new Object[]{error}));
            }
            return result;
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PagedResponse<ConfigurationSetting>> listRevisionsNextPage(String nextPageLink, Context context) {
        try {
            Mono result = this.service.listKeyValues(this.serviceEndpoint, nextPageLink, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
            return result;
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<ConfigurationSetting> listRevisions(SettingSelector selector, Context context) {
        return new PagedFlux(() -> this.listRevisionsFirstPage(selector, context), continuationToken -> this.listRevisionsNextPage((String)continuationToken, context));
    }

    private Flux<ConfigurationSetting> listConfigurationSettings(String nextPageLink, Context context) {
        Mono result = this.service.listKeyValues(this.serviceEndpoint, nextPageLink, context.addData((Object)"az.namespace", (Object)APP_CONFIG_TRACING_NAMESPACE_VALUE)).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error}));
        return result.flatMapMany(r -> this.extractAndFetchConfigurationSettings((PagedResponse<ConfigurationSetting>)r, context));
    }

    public void updateSyncToken(String token) {
        Objects.requireNonNull(token, "'token' cannot be null.");
        this.syncTokenPolicy.updateSyncToken(token);
    }

    private Publisher<ConfigurationSetting> extractAndFetchConfigurationSettings(PagedResponse<ConfigurationSetting> page, Context context) {
        return CoreUtils.extractAndFetch(page, (Context)context, this::listConfigurationSettings);
    }

    private static String getETagValue(String etag) {
        return etag == null || etag.equals(ETAG_ANY) ? etag : "\"" + etag + "\"";
    }

    private static void validateSetting(ConfigurationSetting setting) {
        Objects.requireNonNull(setting);
        if (setting.getKey() == null) {
            throw new IllegalArgumentException("Parameter 'key' is required and cannot be null.");
        }
    }

    private static Throwable addConfigurationSettingExceptionMapper(Throwable throwable) {
        if (!(throwable instanceof ResourceNotFoundException)) {
            return throwable;
        }
        ResourceNotFoundException notFoundException = (ResourceNotFoundException)throwable;
        return new ResourceModifiedException(notFoundException.getMessage(), notFoundException.getResponse());
    }
}

