/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncDatabase;
import com.azure.cosmos.encryption.CosmosEncryptionClientBuilder;
import com.azure.cosmos.encryption.CosmosEncryptionDatabase;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceClient(builder=CosmosEncryptionClientBuilder.class)
public final class CosmosEncryptionClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosEncryptionClient.class);
    private final CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient;
    private final KeyEncryptionKeyResolver keyEncryptionKeyResolver;
    private final CosmosAsyncClient cosmosAsyncClient;
    private final CosmosClient cosmosClient;
    private final ImplementationBridgeHelpers.CosmosClientHelper.CosmosClientAccessor cosmosClientAccessor = ImplementationBridgeHelpers.CosmosClientHelper.getCosmosClientAccessor();
    private final String keyEncryptionKeyResolverName;

    CosmosEncryptionClient(CosmosClient cosmosClient, KeyEncryptionKeyResolver keyEncryptionKeyResolver, String keyEncryptionKeyResolverName) {
        this.keyEncryptionKeyResolver = keyEncryptionKeyResolver;
        this.cosmosClient = cosmosClient;
        this.cosmosAsyncClient = this.cosmosClientAccessor.getCosmosAsyncClient(cosmosClient);
        this.cosmosEncryptionAsyncClient = new CosmosEncryptionAsyncClient(this.cosmosAsyncClient, keyEncryptionKeyResolver, keyEncryptionKeyResolverName);
        this.keyEncryptionKeyResolverName = keyEncryptionKeyResolverName;
    }

    public KeyEncryptionKeyResolver getEncryptionKeyWrapProvider() {
        return this.keyEncryptionKeyResolver;
    }

    public String getKeyEncryptionKeyResolverName() {
        return this.keyEncryptionKeyResolverName;
    }

    public CosmosClient getCosmosClient() {
        return this.cosmosClient;
    }

    public CosmosEncryptionDatabase getCosmosEncryptionDatabase(String databaseId) {
        CosmosDatabase syncDatabase = this.cosmosClient.getDatabase(databaseId);
        CosmosAsyncDatabase asyncDatabase = this.cosmosAsyncClient.getDatabase(databaseId);
        CosmosEncryptionAsyncDatabase cosmosEncryptionAsyncDatabase = new CosmosEncryptionAsyncDatabase(asyncDatabase, this.getCosmosEncryptionAsyncClient());
        return new CosmosEncryptionDatabase(syncDatabase, cosmosEncryptionAsyncDatabase);
    }

    public CosmosEncryptionDatabase getCosmosEncryptionDatabase(CosmosDatabase cosmosDatabase) {
        CosmosAsyncDatabase asyncDatabase = this.cosmosAsyncClient.getDatabase(cosmosDatabase.getId());
        CosmosEncryptionAsyncDatabase cosmosEncryptionAsyncDatabase = new CosmosEncryptionAsyncDatabase(asyncDatabase, this.getCosmosEncryptionAsyncClient());
        return new CosmosEncryptionDatabase(cosmosDatabase, cosmosEncryptionAsyncDatabase);
    }

    CosmosEncryptionAsyncClient getCosmosEncryptionAsyncClient() {
        return this.cosmosEncryptionAsyncClient;
    }

    @Override
    public void close() {
        this.cosmosClient.close();
    }
}

