/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.encryption.models.SqlQuerySpecWithEncryption;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkOperationResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CosmosEncryptionContainer {
    private final CosmosContainer cosmosContainer;
    private final CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer;

    CosmosEncryptionContainer(CosmosContainer container, CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer) {
        this.cosmosContainer = container;
        this.cosmosEncryptionAsyncContainer = cosmosEncryptionAsyncContainer;
    }

    public <T> CosmosItemResponse<T> createItem(T item) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.createItem(item));
    }

    public <T> CosmosItemResponse<T> createItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.createItem(item, options));
    }

    public <T> CosmosItemResponse<T> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.createItem(item, partitionKey, requestOptions));
    }

    public CosmosItemResponse<Object> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return this.blockDeleteItemResponse(this.cosmosEncryptionAsyncContainer.deleteItem(itemId, partitionKey, requestOptions));
    }

    public <T> CosmosItemResponse<Object> deleteItem(T item, CosmosItemRequestOptions options) {
        return this.blockDeleteItemResponse(this.cosmosEncryptionAsyncContainer.deleteItem(item, options));
    }

    CosmosItemResponse<Object> deleteAllItemsByPartitionKey(PartitionKey partitionKey, CosmosItemRequestOptions options) {
        return this.blockDeleteItemResponse(this.cosmosEncryptionAsyncContainer.deleteAllItemsByPartitionKey(partitionKey, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.upsertItem(item));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item, CosmosItemRequestOptions options) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.upsertItem(item, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.upsertItem(item, partitionKey, requestOptions));
    }

    public <T> CosmosItemResponse<T> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.replaceItem(item, itemId, partitionKey, requestOptions));
    }

    public <T> CosmosItemResponse<T> readItem(String id, PartitionKey partitionKey, Class<T> classType) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.readItem(id, partitionKey, new CosmosItemRequestOptions(), classType));
    }

    public <T> CosmosItemResponse<T> readItem(String id, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Class<T> classType) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.readItem(id, partitionKey, requestOptions, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(String query, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
        return this.getCosmosPagedIterable(this.cosmosEncryptionAsyncContainer.queryItems(query, requestOptions, classType));
    }

    public <T> CosmosPagedIterable<T> queryItems(SqlQuerySpec query, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
        return this.getCosmosPagedIterable(this.cosmosEncryptionAsyncContainer.queryItems(query, requestOptions, classType));
    }

    public <T> CosmosPagedIterable<T> queryItemsOnEncryptedProperties(SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption, CosmosQueryRequestOptions options, Class<T> classType) {
        return this.getCosmosPagedIterable(this.cosmosEncryptionAsyncContainer.queryItemsOnEncryptedProperties(sqlQuerySpecWithEncryption, options, classType));
    }

    <T> CosmosPagedIterable<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull((Object)options, (Object)"Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, (Object)"Argument 'classType' must not be null.");
        options.setMaxPrefetchPageCount(1);
        return this.getCosmosPagedIterable(this.cosmosEncryptionAsyncContainer.queryChangeFeed(options, classType));
    }

    public CosmosBatchResponse executeCosmosBatch(CosmosBatch cosmosBatch) {
        return this.blockBatchResponse(this.cosmosEncryptionAsyncContainer.executeCosmosBatch(cosmosBatch));
    }

    public CosmosBatchResponse executeCosmosBatch(CosmosBatch cosmosBatch, CosmosBatchRequestOptions requestOptions) {
        return this.blockBatchResponse(this.cosmosEncryptionAsyncContainer.executeCosmosBatch(cosmosBatch, requestOptions));
    }

    public <T> CosmosItemResponse<T> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        return this.blockItemResponse(this.cosmosEncryptionAsyncContainer.patchItem(itemId, partitionKey, cosmosPatchOperations, options, itemType));
    }

    public <TContext> Iterable<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Iterable<CosmosItemOperation> operations) {
        return this.blockBulkResponse(this.cosmosEncryptionAsyncContainer.executeBulkOperations((Flux<CosmosItemOperation>)Flux.fromIterable(operations)));
    }

    public <TContext> Iterable<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Iterable<CosmosItemOperation> operations, CosmosBulkExecutionOptions bulkOptions) {
        return this.blockBulkResponse(this.cosmosEncryptionAsyncContainer.executeBulkOperations((Flux<CosmosItemOperation>)Flux.fromIterable(operations), bulkOptions));
    }

    public CosmosContainer getCosmosContainer() {
        return this.cosmosContainer;
    }

    private <T> CosmosItemResponse<T> blockItemResponse(Mono<CosmosItemResponse<T>> itemMono) {
        try {
            return (CosmosItemResponse)itemMono.block();
        }
        catch (Exception ex) {
            if (ex instanceof CosmosException) {
                throw (CosmosException)ex;
            }
            throw ex;
        }
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return new CosmosPagedIterable(cosmosPagedFlux);
    }

    private CosmosItemResponse<Object> blockDeleteItemResponse(Mono<CosmosItemResponse<Object>> deleteItemMono) {
        try {
            return (CosmosItemResponse)deleteItemMono.block();
        }
        catch (Exception ex) {
            if (ex instanceof CosmosException) {
                throw (CosmosException)ex;
            }
            throw ex;
        }
    }

    private CosmosBatchResponse blockBatchResponse(Mono<CosmosBatchResponse> batchResponseMono) {
        try {
            return (CosmosBatchResponse)batchResponseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)throwable;
            }
            throw ex;
        }
    }

    private <TContext> List<CosmosBulkOperationResponse<TContext>> blockBulkResponse(Flux<CosmosBulkOperationResponse<TContext>> bulkResponse) {
        try {
            return (List)bulkResponse.collectList().block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)throwable;
            }
            throw ex;
        }
    }
}

