/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.StandardSerializer;
import java.nio.ByteBuffer;
import java.util.UUID;

class UuidSerializer
extends StandardSerializer {
    UuidSerializer() {
    }

    @Override
    public byte[] serialize(Object value) {
        if (value != null) {
            ByteBuffer b = ByteBuffer.wrap(new byte[16]);
            b.putLong(((UUID)value).getMostSignificantBits());
            b.putLong(((UUID)value).getLeastSignificantBits());
            return b.array();
        }
        return null;
    }

    @Override
    public UUID deserialize(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        ByteBuffer b = ByteBuffer.wrap(bytes);
        Long high = b.getLong();
        Long low = b.getLong();
        return new UUID(high, low);
    }
}

