/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionKeyStoreProvider;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import java.util.concurrent.ConcurrentHashMap;

public class UserKeyStoreProviderCatalog<T> {
    private static UserKeyStoreProviderCatalog<?> instance = null;
    private ConcurrentHashMap<T, ConcurrentHashMap<String, EncryptionKeyStoreProvider>> keyStorage = new ConcurrentHashMap();

    private UserKeyStoreProviderCatalog() {
    }

    public static <T> UserKeyStoreProviderCatalog<?> getInstance() {
        if (null == instance) {
            instance = new UserKeyStoreProviderCatalog<T>();
        }
        return instance;
    }

    public void registerKeyStoreProvider(T userKey, EncryptionKeyStoreProvider encryptionKeyStoreProvider) {
        this.keyStorage.put(userKey, new ConcurrentHashMap());
    }

    public EncryptionKeyStoreProvider getKeyStoreProvider(T userKey, String providerName) throws MicrosoftDataEncryptionException {
        this.keyStorage.put(userKey, new ConcurrentHashMap());
        ConcurrentHashMap<String, EncryptionKeyStoreProvider> value = this.keyStorage.get(userKey);
        EncryptionKeyStoreProvider provider = value.get(userKey);
        if (provider != null) {
            return provider;
        }
        throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_KeystoreProviderError"));
    }

    public void clearUserProviders(T userKey) {
        this.keyStorage.remove(userKey);
    }

    public void clear() {
        this.keyStorage.clear();
    }
}

