/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.BooleanSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ByteSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.CharSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DateSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DoubleSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.FloatSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ISerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.IntegerSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.LongSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Serializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SerializerFactory;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.StandardSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.StringSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Type;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.UuidSerializer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StandardSerializerFactory
extends SerializerFactory {
    private Map<String, ISerializer> serializers = new ConcurrentHashMap<String, ISerializer>();

    @Override
    public ISerializer getSerializer(String id) throws MicrosoftDataEncryptionException {
        Serializer<?> s = this.serializers.get(id);
        if (null == s) {
            s = this.createSerializer(id);
        }
        return s;
    }

    public <T> Serializer<T> getDefaultSerializer(String name) throws MicrosoftDataEncryptionException {
        return (Serializer)this.getSerializer(name);
    }

    @Override
    public <T> Serializer<T> getDefaultSerializer(Class<?> clazz) throws MicrosoftDataEncryptionException {
        return (Serializer)this.getSerializer(clazz.getName());
    }

    @Override
    public void registerSerializer(Type type, ISerializer s, boolean overrideDefault) {
        if (null == type || !overrideDefault && this.serializers.containsKey(type.getId())) {
            return;
        }
        this.serializers.put(type.getId(), s);
    }

    private Serializer<?> createSerializer(String id) throws MicrosoftDataEncryptionException {
        StandardSerializer s = null;
        switch (id) {
            case "java.lang.Boolean": {
                s = new BooleanSerializer();
                break;
            }
            case "java.lang.Integer": {
                s = new IntegerSerializer();
                break;
            }
            case "java.lang.Long": {
                s = new LongSerializer();
                break;
            }
            case "java.lang.Byte": {
                s = new ByteSerializer();
                break;
            }
            case "java.lang.Double": {
                s = new DoubleSerializer();
                break;
            }
            case "java.lang.Float": {
                s = new FloatSerializer();
                break;
            }
            case "java.lang.String": {
                s = new StringSerializer();
                break;
            }
            case "java.lang.Character": {
                s = new CharSerializer();
                break;
            }
            case "java.util.UUID": {
                s = new UuidSerializer();
                break;
            }
            case "java.util.Date": {
                s = new DateSerializer();
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidSerializerName"));
                Object[] msgArgs = new Object[]{id.toLowerCase()};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        this.serializers.put(id, s);
        return s;
    }
}

