/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DateTimeOffset;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.text.MessageFormat;

class SqlDatetimeoffsetSerializer
extends SqlSerializer {
    private int defaultPrecision = 7;
    private int minPrecision = 0;
    private int maxPrecision = 7;

    public SqlDatetimeoffsetSerializer(int size, int precision, int scale) throws MicrosoftDataEncryptionException {
        this.precision = precision == 0 ? this.defaultPrecision : precision;
        if (this.precision < this.minPrecision || this.precision > this.maxPrecision) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_parameterOutOfRange"));
            Object[] msgArgs = new Object[]{"precision"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        this.size = size;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return SqlSerializerUtil.normalizedValue(JDBCType.DATETIMEOFFSET, value, this.precision, this.scale);
        }
        return null;
    }

    @Override
    public DateTimeOffset deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (DateTimeOffset)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.DATETIMEOFFSET, SSType.DATETIMEOFFSET, this.precision, this.scale, null);
    }
}

