/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SecurityUtility {
    static final int GONE = 410;
    static final int TOO_MANY_RESQUESTS = 429;
    static final int NOT_FOUND = 404;
    static final int INTERNAL_SERVER_ERROR = 500;
    static final int NETWORK_CONNECT_TIMEOUT_ERROR = 599;

    SecurityUtility() {
    }

    static byte[] getHMACWithSHA256(byte[] plainText, byte[] key, int length) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] hash = new byte[length];
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec ivkeySpec = new SecretKeySpec(key, "HmacSHA256");
        mac.init(ivkeySpec);
        byte[] computedHash = mac.doFinal(plainText);
        System.arraycopy(computedHash, 0, hash, 0, hash.length);
        return hash;
    }

    static boolean compareBytes(byte[] buffer1, byte[] buffer2, int buffer2Index, int lengthToCompare) {
        if (null == buffer1 || null == buffer2) {
            return false;
        }
        if (buffer2.length - buffer2Index < lengthToCompare) {
            return false;
        }
        for (int index = 0; index < buffer1.length && index < lengthToCompare; ++index) {
            if (buffer1[index] == buffer2[buffer2Index + index]) continue;
            return false;
        }
        return true;
    }
}

