/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Triple;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class ProtectedDataEncryptionKey
extends DataEncryptionKey {
    private KeyEncryptionKey keyEncryptionKey;
    private byte[] encryptedValue;

    public KeyEncryptionKey getKeyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public byte[] getEncryptedValue() {
        return this.encryptedValue;
    }

    public static ProtectedDataEncryptionKey getOrCreate(String name, KeyEncryptionKey keyEncryptionKey, byte[] encryptedKey) throws MicrosoftDataEncryptionException, InvalidKeyException, NoSuchAlgorithmException {
        Utils.validateNotNullOrWhitespace(name, "name");
        Utils.validateNotNull(keyEncryptionKey, "keyEncryptionKey");
        Utils.validateNotNull(encryptedKey, "encryptedKey");
        return new ProtectedDataEncryptionKey(name, keyEncryptionKey, encryptedKey);
    }

    public ProtectedDataEncryptionKey(String name, KeyEncryptionKey keyEncryptionKey) throws NoSuchAlgorithmException, MicrosoftDataEncryptionException, InvalidKeyException {
        this(name, keyEncryptionKey, ProtectedDataEncryptionKey.generateNewColumnEncryptionKey(keyEncryptionKey));
    }

    public ProtectedDataEncryptionKey(String name, KeyEncryptionKey keyEncryptionKey, byte[] encryptedKey) throws MicrosoftDataEncryptionException, InvalidKeyException, NoSuchAlgorithmException {
        super(name, keyEncryptionKey.decryptEncryptionKey(encryptedKey));
        Utils.validateNotNullOrWhitespace(name, "name");
        Utils.validateNotNull(keyEncryptionKey, "keyEncryptionKey");
        this.keyEncryptionKey = keyEncryptionKey;
        this.encryptedValue = encryptedKey;
    }

    public ProtectedDataEncryptionKey(String name, byte[] rootKey) throws MicrosoftDataEncryptionException, InvalidKeyException, NoSuchAlgorithmException {
        super(name, rootKey);
        Utils.validateNotNullOrWhitespace(name, "name");
        Utils.validateNotNull(rootKey, "rootkey");
    }

    private static byte[] generateNewColumnEncryptionKey(KeyEncryptionKey kek) throws NoSuchAlgorithmException, MicrosoftDataEncryptionException {
        byte[] plainTextColumnEncryptionKey = new byte[32];
        SecureRandom.getInstanceStrong().nextBytes(plainTextColumnEncryptionKey);
        return kek.encryptEncryptionKey(plainTextColumnEncryptionKey);
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof ProtectedDataEncryptionKey)) {
            return false;
        }
        ProtectedDataEncryptionKey other = (ProtectedDataEncryptionKey)obj;
        if (null == this.keyEncryptionKey && null == other.keyEncryptionKey) {
            return true;
        }
        if (null != this.keyEncryptionKey && null != this.name && null != this.rootKeyHexString) {
            return this.keyEncryptionKey.equals(other.keyEncryptionKey) && this.name.equals(other.name) && this.rootKeyHexString.equals(other.rootKeyHexString);
        }
        return false;
    }

    public int hashCode() {
        return new Triple<String, KeyEncryptionKey, String>(this.name, this.keyEncryptionKey, this.rootKeyHexString).hashCode();
    }
}

