/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKeyAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Quadruple;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EncryptionKeyStoreProvider {
    protected Map<String, byte[]> dataEncryptionKeyCache = new ConcurrentHashMap<String, byte[]>();
    protected Map<Quadruple<String, String, Boolean, String>, Boolean> keyEncryptionKeyMetadataSignatureVerificationCache = new ConcurrentHashMap<Quadruple<String, String, Boolean, String>, Boolean>(){};
    protected String providerName;

    public abstract String getProviderName();

    public abstract byte[] unwrapKey(String var1, KeyEncryptionKeyAlgorithm var2, byte[] var3) throws MicrosoftDataEncryptionException;

    public abstract byte[] wrapKey(String var1, KeyEncryptionKeyAlgorithm var2, byte[] var3) throws MicrosoftDataEncryptionException;

    public abstract byte[] sign(String var1, boolean var2) throws MicrosoftDataEncryptionException;

    public abstract boolean verify(String var1, boolean var2, byte[] var3) throws MicrosoftDataEncryptionException;

    protected byte[] getOrCreateDataEncryptionKey(String encryptedDataEncryptionKey, byte[] createItem) {
        return this.dataEncryptionKeyCache.put(encryptedDataEncryptionKey, createItem);
    }

    protected boolean getOrCreateSignatureVerificationResult(Quadruple<String, String, Boolean, String> keyInformation, boolean createItem) {
        return this.keyEncryptionKeyMetadataSignatureVerificationCache.put(keyInformation, createItem);
    }
}

