/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.CryptographyExtensions;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SecurityUtility;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;

public abstract class DataEncryptionKey {
    protected String rootKeyHexString;
    private final int KEY_SIZE_IN_BITS = 256;
    public final int KEY_SIZE_IN_BYTES = 32;
    protected String name;
    private byte[] rootKeyBytes;
    private byte[] encryptionKeyBytes;
    private byte[] macKeyBytes;
    private byte[] ivKeyBytes;

    protected DataEncryptionKey(String name, byte[] rootKey) throws MicrosoftDataEncryptionException, InvalidKeyException, NoSuchAlgorithmException {
        if (null == name || name.trim().isEmpty()) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataEncryptionKey"));
        }
        if (32 != rootKey.length) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidKeySize"));
            Object[] msgArgs = new Object[]{32};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        this.name = name;
        String encryptionKeySalt = "Microsoft SQL Server cell encryption key with encryption algorithm:AEAD_AES_256_CBC_HMAC_SHA256 and key length:256";
        String macKeySalt = "Microsoft SQL Server cell MAC key with encryption algorithm:AEAD_AES_256_CBC_HMAC_SHA256 and key length:256";
        String ivKeySalt = "Microsoft SQL Server cell IV key with encryption algorithm:AEAD_AES_256_CBC_HMAC_SHA256 and key length:256";
        byte[] encryptionKeyBytes = SecurityUtility.getHMACWithSHA256(encryptionKeySalt.getBytes(StandardCharsets.UTF_16LE), rootKey, 32);
        byte[] macKeyBytes = SecurityUtility.getHMACWithSHA256(macKeySalt.getBytes(StandardCharsets.UTF_16LE), rootKey, 32);
        byte[] ivKeyBytes = SecurityUtility.getHMACWithSHA256(ivKeySalt.getBytes(StandardCharsets.UTF_16LE), rootKey, 32);
        this.rootKeyBytes = rootKey;
        this.encryptionKeyBytes = encryptionKeyBytes;
        this.macKeyBytes = macKeyBytes;
        this.ivKeyBytes = ivKeyBytes;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String value) {
        this.name = value;
    }

    protected byte[] getRootKeyBytes() {
        return this.rootKeyBytes;
    }

    protected void setRootKeyBytes(byte[] value) {
        this.rootKeyBytes = value;
        this.rootKeyHexString = CryptographyExtensions.toBase64String(value);
    }

    protected String getRootKeyHexString() {
        return this.rootKeyHexString;
    }

    protected byte[] getEncryptionKeyBytes() {
        return this.encryptionKeyBytes;
    }

    protected void setEncryptionKeyBytes(byte[] value) {
        this.encryptionKeyBytes = value;
    }

    protected byte[] getMacKeyBytes() {
        return this.macKeyBytes;
    }

    protected void setMacKeyBytes(byte[] value) {
        this.macKeyBytes = value;
    }

    protected byte[] getIvKeyBytes() {
        return this.ivKeyBytes;
    }

    protected void setIvKeyBytes(byte[] value) {
        this.ivKeyBytes = value;
    }

    public boolean rootKeyEquals(DataEncryptionKey otherKey) {
        return this.rootKeyHexString.equals(otherKey.rootKeyHexString);
    }
}

