/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.encryption.implementation.EncryptionProcessor;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.PrimitiveJsonNodeMap;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.Transformer;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class CosmosEncryptionQueryTransformer<T>
implements Transformer<T> {
    private static final ImplementationBridgeHelpers.CosmosItemSerializerHelper.CosmosItemSerializerAccessor itemSerializerAccessor = ImplementationBridgeHelpers.CosmosItemSerializerHelper.getCosmosItemSerializerAccessor();
    private final Scheduler encryptionScheduler;
    private final EncryptionProcessor encryptionProcessor;
    private final Class<T> classType;
    private final boolean isChangeFeed;

    public CosmosEncryptionQueryTransformer(Scheduler encryptionScheduler, EncryptionProcessor encryptionProcessor, Class<T> classType, Boolean isChangeFeed) {
        this.encryptionScheduler = encryptionScheduler;
        this.encryptionProcessor = encryptionProcessor;
        this.classType = classType;
        this.isChangeFeed = isChangeFeed;
    }

    public Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> transform(Function<CosmosPagedFluxOptions, Flux<FeedResponse<JsonNode>>> func, CosmosItemSerializer effectiveSerializer) {
        return this.queryDecryptionTransformer(this.classType, this.isChangeFeed, func, effectiveSerializer);
    }

    private <TTransform> Function<CosmosPagedFluxOptions, Flux<FeedResponse<TTransform>>> queryDecryptionTransformer(Class<TTransform> classType, boolean isChangeFeed, Function<CosmosPagedFluxOptions, Flux<FeedResponse<JsonNode>>> func, CosmosItemSerializer effectiveSerializer) {
        return func.andThen(flux -> flux.publishOn(this.encryptionScheduler).flatMap(page -> {
            boolean useEtagAsContinuation = isChangeFeed;
            boolean isNoChangesResponse = isChangeFeed ? ModelBridgeInternal.getNoChangesFromFeedResponse((FeedResponse)page) : false;
            List jsonNodeArrayMonoList = page.getResults().stream().map(jsonNode -> this.decryptResponseNode((JsonNode)jsonNode)).collect(Collectors.toList());
            return Flux.concat(jsonNodeArrayMonoList).map(item -> {
                ObjectNodeMap decryptedJsonTree;
                if (item instanceof ObjectNode) {
                    decryptedJsonTree = new ObjectNodeMap((ObjectNode)item);
                } else if (item.isValueNode()) {
                    decryptedJsonTree = new PrimitiveJsonNodeMap(item);
                } else {
                    return Utils.getSimpleObjectMapper().convertValue(item, classType);
                }
                return itemSerializerAccessor.deserializeSafe(effectiveSerializer, (Map)decryptedJsonTree, classType);
            }).collectList().map(itemList -> BridgeInternal.createFeedResponseWithQueryMetrics((List)itemList, (Map)page.getResponseHeaders(), (ConcurrentMap)BridgeInternal.queryMetricsFromFeedResponse((FeedResponse)page), (QueryInfo.QueryPlanDiagnosticsContext)ModelBridgeInternal.getQueryPlanDiagnosticsContext((FeedResponse)page), (boolean)useEtagAsContinuation, (boolean)isNoChangesResponse, (CosmosDiagnostics)page.getCosmosDiagnostics()));
        }));
    }

    Mono<JsonNode> decryptResponseNode(JsonNode jsonNode) {
        if (jsonNode == null) {
            return Mono.empty();
        }
        return this.encryptionProcessor.decryptJsonNode(jsonNode);
    }
}

