/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.cosmos.CosmosAsyncClientEncryptionKey;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataEncryptionKeyAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ProtectedDataEncryptionKey;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.EncryptionKeyWrapMetadata;
import com.azure.cosmos.util.CosmosPagedFlux;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import reactor.core.publisher.Mono;

public final class CosmosEncryptionAsyncDatabase {
    private final CosmosAsyncDatabase cosmosAsyncDatabase;
    private final CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient;
    private static final ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.CosmosAsyncClientEncryptionKeyAccessor cosmosAsyncClientEncryptionKeyAccessor = ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.getCosmosAsyncClientEncryptionKeyAccessor();

    CosmosEncryptionAsyncDatabase(CosmosAsyncDatabase cosmosAsyncDatabase, CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient) {
        this.cosmosAsyncDatabase = cosmosAsyncDatabase;
        this.cosmosEncryptionAsyncClient = cosmosEncryptionAsyncClient;
    }

    public CosmosAsyncClientEncryptionKey getClientEncryptionKey(String id) {
        return this.cosmosAsyncDatabase.getClientEncryptionKey(id);
    }

    public CosmosPagedFlux<CosmosClientEncryptionKeyProperties> readAllClientEncryptionKeys() {
        return this.cosmosAsyncDatabase.readAllClientEncryptionKeys();
    }

    public Mono<CosmosClientEncryptionKeyResponse> createClientEncryptionKey(String clientEncryptionKeyId, String encryptionAlgorithm, EncryptionKeyWrapMetadata encryptionKeyWrapMetadata) {
        if (StringUtils.isEmpty((CharSequence)clientEncryptionKeyId)) {
            throw new IllegalArgumentException("clientEncryptionKeyId is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)encryptionAlgorithm)) {
            throw new IllegalArgumentException("encryptionAlgorithm is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)encryptionKeyWrapMetadata.getAlgorithm())) {
            throw new IllegalArgumentException("Key Encryption Key Algorithm in EncryptionKeyWrapMetadata is null or empty");
        }
        if (!encryptionAlgorithm.equals(DataEncryptionKeyAlgorithm.AEAD_AES_256_CBC_HMAC_SHA256.toString())) {
            throw new IllegalArgumentException(String.format("Invalid Data Encryption Algorithm '%s'", encryptionAlgorithm));
        }
        if (!encryptionKeyWrapMetadata.getAlgorithm().equals("RSA-OAEP")) {
            throw new IllegalArgumentException(String.format("Invalid Key Encryption Key Algorithm in EncryptionKeyWrapMetadata '%s'", encryptionKeyWrapMetadata.getAlgorithm()));
        }
        if (!this.cosmosEncryptionAsyncClient.getKeyEncryptionKeyResolverName().equals(encryptionKeyWrapMetadata.getType())) {
            throw new IllegalArgumentException("The EncryptionKeyWrapMetadata Type value does not match with the keyEncryptionKeyResolverName configured on the Client. Please refer to https://aka.ms/CosmosClientEncryption for more details.");
        }
        try {
            KeyEncryptionKey keyEncryptionKey = KeyEncryptionKey.getOrCreate(encryptionKeyWrapMetadata.getName(), encryptionKeyWrapMetadata.getValue(), this.cosmosEncryptionAsyncClient.getEncryptionKeyStoreProviderImpl(), false);
            ProtectedDataEncryptionKey protectedDataEncryptionKey = new ProtectedDataEncryptionKey(clientEncryptionKeyId, keyEncryptionKey);
            byte[] wrappedDataEncryptionKey = protectedDataEncryptionKey.getEncryptedValue();
            CosmosClientEncryptionKeyProperties clientEncryptionKeyProperties = new CosmosClientEncryptionKeyProperties(clientEncryptionKeyId, encryptionAlgorithm, wrappedDataEncryptionKey, encryptionKeyWrapMetadata);
            return this.cosmosAsyncDatabase.createClientEncryptionKey(clientEncryptionKeyProperties);
        }
        catch (MicrosoftDataEncryptionException | InvalidKeyException | NoSuchAlgorithmException ex) {
            return Mono.error((Throwable)ex);
        }
    }

    public Mono<CosmosClientEncryptionKeyResponse> rewrapClientEncryptionKey(String clientEncryptionKeyId, EncryptionKeyWrapMetadata newEncryptionKeyWrapMetadata) {
        if (StringUtils.isEmpty((CharSequence)clientEncryptionKeyId)) {
            throw new IllegalArgumentException("clientEncryptionKeyId is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)newEncryptionKeyWrapMetadata.getAlgorithm())) {
            throw new IllegalArgumentException("Key Encryption Key Algorithm in EncryptionKeyWrapMetadata is null or empty");
        }
        if (!this.cosmosEncryptionAsyncClient.getKeyEncryptionKeyResolverName().equals(newEncryptionKeyWrapMetadata.getType())) {
            throw new IllegalArgumentException("The EncryptionKeyWrapMetadata Type value does not match with the keyEncryptionKeyResolverName configured on the Client. Please refer to https://aka.ms/CosmosClientEncryption for more details.");
        }
        if (!newEncryptionKeyWrapMetadata.getAlgorithm().equals("RSA-OAEP")) {
            throw new IllegalArgumentException(String.format("Invalid Key Encryption Key Algorithm in EncryptionKeyWrapMetadata '%s'", newEncryptionKeyWrapMetadata.getAlgorithm()));
        }
        try {
            CosmosAsyncClientEncryptionKey clientEncryptionKey = this.cosmosAsyncDatabase.getClientEncryptionKey(clientEncryptionKeyId);
            return cosmosAsyncClientEncryptionKeyAccessor.readClientEncryptionKey(clientEncryptionKey, null).flatMap(cosmosClientEncryptionKeyResponse -> {
                CosmosClientEncryptionKeyProperties clientEncryptionKeyProperties = cosmosClientEncryptionKeyResponse.getProperties();
                try {
                    KeyEncryptionKey keyEncryptionKey = KeyEncryptionKey.getOrCreate(clientEncryptionKeyProperties.getEncryptionKeyWrapMetadata().getName(), clientEncryptionKeyProperties.getEncryptionKeyWrapMetadata().getValue(), this.cosmosEncryptionAsyncClient.getEncryptionKeyStoreProviderImpl(), false);
                    byte[] unwrappedKey = keyEncryptionKey.decryptEncryptionKey(clientEncryptionKeyProperties.getWrappedDataEncryptionKey());
                    keyEncryptionKey = KeyEncryptionKey.getOrCreate(newEncryptionKeyWrapMetadata.getName(), newEncryptionKeyWrapMetadata.getValue(), this.cosmosEncryptionAsyncClient.getEncryptionKeyStoreProviderImpl(), false);
                    byte[] rewrappedKey = keyEncryptionKey.encryptEncryptionKey(unwrappedKey);
                    clientEncryptionKeyProperties = new CosmosClientEncryptionKeyProperties(clientEncryptionKeyId, clientEncryptionKeyProperties.getEncryptionAlgorithm(), rewrappedKey, newEncryptionKeyWrapMetadata);
                    return clientEncryptionKey.replace(clientEncryptionKeyProperties);
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    public CosmosEncryptionAsyncContainer getCosmosEncryptionAsyncContainer(CosmosAsyncContainer container) {
        return new CosmosEncryptionAsyncContainer(container, this.cosmosEncryptionAsyncClient);
    }

    public CosmosEncryptionAsyncContainer getCosmosEncryptionAsyncContainer(String containerId) {
        CosmosAsyncContainer cosmosAsyncContainer = this.cosmosAsyncDatabase.getContainer(containerId);
        return new CosmosEncryptionAsyncContainer(cosmosAsyncContainer, this.cosmosEncryptionAsyncClient);
    }

    CosmosEncryptionAsyncClient getCosmosEncryptionAsyncClient() {
        return this.cosmosEncryptionAsyncClient;
    }

    public CosmosAsyncDatabase getCosmosAsyncDatabase() {
        return this.cosmosAsyncDatabase;
    }
}

