/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.models;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CosmosEncryptionType {
    RANDOMIZED("Randomized"),
    DETERMINISTIC("Deterministic");

    private final String encryptionType;
    private static final Map<String, CosmosEncryptionType> ENUM_MAP;

    private CosmosEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String toString() {
        return this.encryptionType;
    }

    public String getName() {
        return this.encryptionType;
    }

    public static CosmosEncryptionType get(String name) {
        return ENUM_MAP.get(name);
    }

    static {
        ConcurrentHashMap<String, CosmosEncryptionType> map = new ConcurrentHashMap<String, CosmosEncryptionType>();
        for (CosmosEncryptionType instance : CosmosEncryptionType.values()) {
            map.put(instance.getName(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

