/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.implementation.EncryptionImplementationBridgeHelpers;
import com.azure.cosmos.encryption.implementation.EncryptionSettings;
import com.azure.cosmos.encryption.implementation.EncryptionUtils;
import com.azure.cosmos.encryption.implementation.keyprovider.EncryptionKeyStoreProviderImpl;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ProtectedDataEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerFactory;
import com.azure.cosmos.encryption.models.CosmosEncryptionType;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.models.ClientEncryptionIncludedPath;
import com.azure.cosmos.models.ClientEncryptionPolicy;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class EncryptionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionProcessor.class);
    private CosmosEncryptionAsyncClient encryptionCosmosClient;
    private CosmosAsyncContainer cosmosAsyncContainer;
    private EncryptionSettings encryptionSettings;
    private AtomicBoolean isEncryptionSettingsInitDone;
    private ClientEncryptionPolicy clientEncryptionPolicy;
    private String containerRid;
    private String databaseRid;
    private CosmosClientEncryptionKeyProperties cosmosClientEncryptionKeyProperties;
    private final EncryptionKeyStoreProviderImpl encryptionKeyStoreProviderImpl;
    private static final ImplementationBridgeHelpers.CosmosContainerPropertiesHelper.CosmosContainerPropertiesAccessor cosmosContainerPropertiesAccessor = ImplementationBridgeHelpers.CosmosContainerPropertiesHelper.getCosmosContainerPropertiesAccessor();
    private static final EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.CosmosEncryptionAsyncClientAccessor cosmosEncryptionAsyncClientAccessor = EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.getCosmosEncryptionAsyncClientAccessor();

    public EncryptionProcessor(CosmosAsyncContainer cosmosAsyncContainer, CosmosEncryptionAsyncClient encryptionCosmosClient) {
        if (cosmosAsyncContainer == null) {
            throw new IllegalStateException("encryptionCosmosContainer is null");
        }
        if (encryptionCosmosClient == null) {
            throw new IllegalStateException("encryptionCosmosClient is null");
        }
        this.cosmosAsyncContainer = cosmosAsyncContainer;
        this.encryptionCosmosClient = encryptionCosmosClient;
        this.isEncryptionSettingsInitDone = new AtomicBoolean(false);
        this.encryptionKeyStoreProviderImpl = cosmosEncryptionAsyncClientAccessor.getEncryptionKeyStoreProviderImpl(this.encryptionCosmosClient);
        this.encryptionSettings = new EncryptionSettings();
    }

    public Mono<Void> initializeEncryptionSettingsAsync(boolean isRetry) {
        if (this.isEncryptionSettingsInitDone.get()) {
            throw new IllegalStateException("The Encryption Processor has already been initialized. ");
        }
        ConcurrentHashMap settingsByDekId = new ConcurrentHashMap();
        return cosmosEncryptionAsyncClientAccessor.getContainerPropertiesAsync(this.encryptionCosmosClient, this.cosmosAsyncContainer, isRetry).flatMap(cosmosContainerProperties -> {
            this.containerRid = cosmosContainerProperties.getResourceId();
            this.databaseRid = cosmosContainerPropertiesAccessor.getSelfLink(cosmosContainerProperties).split("/")[1];
            this.encryptionSettings.setDatabaseRid(this.databaseRid);
            if (cosmosContainerProperties.getClientEncryptionPolicy() == null) {
                this.isEncryptionSettingsInitDone.set(true);
                return Mono.empty();
            }
            this.clientEncryptionPolicy = cosmosContainerProperties.getClientEncryptionPolicy();
            AtomicReference<Mono> sequentialList = new AtomicReference<Mono>();
            ArrayList monoList = new ArrayList();
            this.clientEncryptionPolicy.getIncludedPaths().stream().map(clientEncryptionIncludedPath -> clientEncryptionIncludedPath.getClientEncryptionKeyId()).distinct().forEach(clientEncryptionKeyId -> {
                AtomicBoolean forceRefreshClientEncryptionKey = new AtomicBoolean(false);
                AtomicBoolean forceRefreshClientEncryptionKeyGateway = new AtomicBoolean(false);
                AtomicReference existingCekEtag = new AtomicReference();
                Mono clientEncryptionPropertiesMono = cosmosEncryptionAsyncClientAccessor.getClientEncryptionPropertiesAsync(this.encryptionCosmosClient, (String)clientEncryptionKeyId, this.databaseRid, this.cosmosAsyncContainer, forceRefreshClientEncryptionKey.get(), (String)existingCekEtag.get(), forceRefreshClientEncryptionKeyGateway.get()).publishOn(Schedulers.boundedElastic()).flatMap(keyProperties -> {
                    ProtectedDataEncryptionKey protectedDataEncryptionKey;
                    this.cosmosClientEncryptionKeyProperties = keyProperties;
                    try {
                        protectedDataEncryptionKey = this.encryptionSettings.buildProtectedDataEncryptionKey((CosmosClientEncryptionKeyProperties)keyProperties, this.encryptionKeyStoreProviderImpl, (String)clientEncryptionKeyId);
                    }
                    catch (Exception ex) {
                        return Mono.error((Throwable)ex);
                    }
                    EncryptionSettings encryptionSettings = new EncryptionSettings();
                    encryptionSettings.setDatabaseRid(this.databaseRid);
                    encryptionSettings.setEncryptionSettingTimeToLive(Instant.now().plus(Duration.ofMinutes(60L)));
                    encryptionSettings.setClientEncryptionKeyId((String)clientEncryptionKeyId);
                    encryptionSettings.setDataEncryptionKey(protectedDataEncryptionKey);
                    settingsByDekId.put(clientEncryptionKeyId, encryptionSettings);
                    return Mono.empty();
                }).retryWhen(Retry.withThrowable(throwableFlux -> throwableFlux.flatMap(throwable -> {
                    InvalidKeyException invalidKeyException = (InvalidKeyException)Utils.as((Object)throwable, InvalidKeyException.class);
                    if (invalidKeyException != null && !forceRefreshClientEncryptionKey.get()) {
                        forceRefreshClientEncryptionKey.set(true);
                        return Mono.delay((Duration)Duration.ZERO).flux();
                    }
                    if (invalidKeyException != null && !forceRefreshClientEncryptionKeyGateway.get()) {
                        forceRefreshClientEncryptionKeyGateway.set(true);
                        existingCekEtag.set(this.cosmosClientEncryptionKeyProperties.getETag());
                        return Mono.delay((Duration)Duration.ZERO).flux();
                    }
                    return Flux.error((Throwable)throwable);
                })));
                monoList.add(clientEncryptionPropertiesMono);
            });
            sequentialList.set(Flux.mergeSequential(monoList).collectList());
            return ((Mono)sequentialList.get()).map(objects -> Mono.empty());
        }).flatMap(ignoreVoid -> {
            for (ClientEncryptionIncludedPath propertyToEncrypt : this.clientEncryptionPolicy.getIncludedPaths()) {
                EncryptionType encryptionType = EncryptionType.Plaintext;
                switch (CosmosEncryptionType.get(propertyToEncrypt.getEncryptionType())) {
                    case DETERMINISTIC: {
                        encryptionType = EncryptionType.Deterministic;
                        break;
                    }
                    case RANDOMIZED: {
                        encryptionType = EncryptionType.Randomized;
                        break;
                    }
                    default: {
                        LOGGER.debug("Invalid encryption type {}", (Object)propertyToEncrypt.getEncryptionType());
                    }
                }
                String propertyName = propertyToEncrypt.getPath().substring(1);
                try {
                    this.encryptionSettings.setEncryptionSettingForProperty(propertyName, EncryptionSettings.create((EncryptionSettings)settingsByDekId.get(propertyToEncrypt.getClientEncryptionKeyId()), encryptionType), ((EncryptionSettings)settingsByDekId.get(propertyToEncrypt.getClientEncryptionKeyId())).getEncryptionSettingTimeToLive());
                }
                catch (MicrosoftDataEncryptionException ex) {
                    return Mono.error((Throwable)ex);
                }
            }
            this.isEncryptionSettingsInitDone.set(true);
            return Mono.empty();
        });
    }

    public Mono<Void> initEncryptionSettingsIfNotInitializedAsync() {
        if (!this.isEncryptionSettingsInitDone.get()) {
            return this.initializeEncryptionSettingsAsync(false).then(Mono.empty());
        }
        return Mono.empty();
    }

    ClientEncryptionPolicy getClientEncryptionPolicy() {
        return this.clientEncryptionPolicy;
    }

    void setClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        this.clientEncryptionPolicy = clientEncryptionPolicy;
    }

    public CosmosAsyncContainer getCosmosAsyncContainer() {
        return this.cosmosAsyncContainer;
    }

    public CosmosEncryptionAsyncClient getEncryptionCosmosClient() {
        return this.encryptionCosmosClient;
    }

    public EncryptionSettings getEncryptionSettings() {
        return this.encryptionSettings;
    }

    public Mono<byte[]> encrypt(byte[] payload) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encrypting byte[] of size [{}] on thread [{}]", (Object)(payload == null ? null : Integer.valueOf(payload.length)), (Object)Thread.currentThread().getName());
        }
        ObjectNode itemJObj = (ObjectNode)Utils.parse((byte[])payload, ObjectNode.class);
        return this.encrypt((JsonNode)itemJObj);
    }

    public Mono<byte[]> encrypt(JsonNode itemJObj) {
        return this.encryptObjectNode(itemJObj).map(encryptedObjectNode -> EncryptionUtils.serializeJsonToByteArray(EncryptionUtils.getSimpleObjectMapper(), encryptedObjectNode));
    }

    public Mono<JsonNode> encryptPatchNode(JsonNode itemObj, String patchPropertyPath) {
        assert (itemObj != null);
        return this.initEncryptionSettingsIfNotInitializedAsync().then(Mono.defer(() -> {
            for (ClientEncryptionIncludedPath includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                if (!StringUtils.isEmpty((CharSequence)includedPath.getPath()) && includedPath.getPath().charAt(0) == '/' && includedPath.getPath().lastIndexOf(47) == 0) continue;
                return Mono.error((Throwable)new IllegalArgumentException("Invalid encryption path: " + includedPath.getPath()));
            }
            for (ClientEncryptionIncludedPath includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                String propertyName = includedPath.getPath().substring(1);
                if (!patchPropertyPath.substring(1).equals(propertyName)) continue;
                if (itemObj.isValueNode()) {
                    return this.encryptionSettings.getEncryptionSettingForPropertyAsync(propertyName, this).flatMap(settings -> {
                        try {
                            return Mono.just((Object)EncryptionUtils.getSimpleObjectMapper().readTree(EncryptionUtils.getSimpleObjectMapper().writeValueAsString((Object)this.encryptAndSerializeValue((EncryptionSettings)settings, null, itemObj, propertyName))));
                        }
                        catch (MicrosoftDataEncryptionException | JsonProcessingException ex) {
                            return Mono.error((Throwable)ex);
                        }
                    });
                }
                return this.encryptionSettings.getEncryptionSettingForPropertyAsync(propertyName, this).flatMap(settings -> {
                    try {
                        return Mono.just((Object)this.encryptAndSerializePatchProperty((EncryptionSettings)settings, itemObj, propertyName));
                    }
                    catch (MicrosoftDataEncryptionException | JsonProcessingException ex) {
                        return Mono.error((Throwable)ex);
                    }
                });
            }
            return Mono.empty();
        }));
    }

    public Mono<JsonNode> encryptObjectNode(JsonNode itemJObj) {
        assert (itemJObj != null);
        return this.initEncryptionSettingsIfNotInitializedAsync().then(Mono.defer(() -> {
            for (Object includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                if (!StringUtils.isEmpty((CharSequence)includedPath.getPath()) && includedPath.getPath().charAt(0) == '/' && includedPath.getPath().lastIndexOf(47) == 0) continue;
                return Mono.error((Throwable)new IllegalArgumentException("Invalid encryption path: " + includedPath.getPath()));
            }
            ArrayList<Mono> encryptionMonoList = new ArrayList<Mono>();
            for (ClientEncryptionIncludedPath includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                String propertyName = includedPath.getPath().substring(1);
                JsonNode propertyValueHolder = itemJObj.get(propertyName);
                if (propertyValueHolder == null || propertyValueHolder.isNull()) continue;
                Mono voidMono = this.encryptionSettings.getEncryptionSettingForPropertyAsync(propertyName, this).flatMap(settings -> {
                    try {
                        this.encryptAndSerializeProperty((EncryptionSettings)settings, itemJObj, propertyValueHolder, propertyName);
                    }
                    catch (MicrosoftDataEncryptionException | JsonProcessingException ex) {
                        return Mono.error((Throwable)ex);
                    }
                    return Mono.empty();
                });
                encryptionMonoList.add(voidMono);
            }
            Mono listMono = Flux.mergeSequential(encryptionMonoList).collectList();
            return listMono.map(ignoreVoid -> itemJObj);
        }));
    }

    public JsonNode encryptAndSerializePatchProperty(EncryptionSettings encryptionSettings, JsonNode propertyValueHolder, String propertyName) throws MicrosoftDataEncryptionException, JsonProcessingException {
        if (propertyValueHolder.isObject()) {
            Iterator it = propertyValueHolder.fields();
            while (it.hasNext()) {
                Map.Entry child = (Map.Entry)it.next();
                if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                    JsonNode encryptedValue = this.encryptAndSerializePatchProperty(encryptionSettings, (JsonNode)child.getValue(), (String)child.getKey());
                    assert (propertyValueHolder instanceof ObjectNode);
                    ((ObjectNode)propertyValueHolder).set((String)child.getKey(), encryptedValue);
                    continue;
                }
                if (((JsonNode)child.getValue()).isNull()) continue;
                assert (propertyValueHolder instanceof ObjectNode);
                this.encryptAndSerializeValue(encryptionSettings, (ObjectNode)propertyValueHolder, (JsonNode)child.getValue(), (String)child.getKey());
            }
        } else {
            if (propertyValueHolder.isArray()) {
                assert (propertyValueHolder instanceof ArrayNode);
                ArrayNode arrayNode = (ArrayNode)propertyValueHolder;
                if (((JsonNode)arrayNode.elements().next()).isObject() || ((JsonNode)arrayNode.elements().next()).isArray()) {
                    ArrayList<JsonNode> encryptedArray = new ArrayList<JsonNode>();
                    Iterator arrayIterator = arrayNode.elements();
                    while (arrayIterator.hasNext()) {
                        JsonNode nodeInArray = (JsonNode)arrayIterator.next();
                        if (nodeInArray.isArray()) {
                            encryptedArray.add(this.encryptAndSerializePatchProperty(encryptionSettings, nodeInArray, propertyName));
                            continue;
                        }
                        Iterator it = nodeInArray.fields();
                        while (it.hasNext()) {
                            Map.Entry child = (Map.Entry)it.next();
                            if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                                JsonNode encryptedValue = this.encryptAndSerializePatchProperty(encryptionSettings, (JsonNode)child.getValue(), (String)child.getKey());
                                ((ObjectNode)nodeInArray).set((String)child.getKey(), encryptedValue);
                                continue;
                            }
                            if (((JsonNode)child.getValue()).isNull()) continue;
                            this.encryptAndSerializeValue(encryptionSettings, (ObjectNode)nodeInArray, (JsonNode)child.getValue(), (String)child.getKey());
                        }
                        encryptedArray.add(nodeInArray);
                    }
                    arrayNode.removeAll();
                    for (JsonNode encryptedValue : encryptedArray) {
                        arrayNode.add(encryptedValue);
                    }
                } else {
                    ArrayList<byte[]> encryptedArray = new ArrayList<byte[]>();
                    Iterator it = arrayNode.elements();
                    while (it.hasNext()) {
                        encryptedArray.add(this.encryptAndSerializeValue(encryptionSettings, null, (JsonNode)it.next(), ""));
                    }
                    arrayNode.removeAll();
                    for (byte[] encryptedValue : encryptedArray) {
                        arrayNode.add(encryptedValue);
                    }
                }
                return arrayNode;
            }
            this.encryptAndSerializeValue(encryptionSettings, null, propertyValueHolder, propertyName);
        }
        return propertyValueHolder;
    }

    public void encryptAndSerializeProperty(EncryptionSettings encryptionSettings, JsonNode objectNode, JsonNode propertyValueHolder, String propertyName) throws MicrosoftDataEncryptionException, JsonProcessingException {
        if (propertyValueHolder.isObject()) {
            Iterator it = propertyValueHolder.fields();
            while (it.hasNext()) {
                Map.Entry child = (Map.Entry)it.next();
                if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                    this.encryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)propertyValueHolder), (JsonNode)child.getValue(), propertyName);
                    continue;
                }
                if (((JsonNode)child.getValue()).isNull()) continue;
                this.encryptAndSerializeValue(encryptionSettings, (ObjectNode)propertyValueHolder, (JsonNode)child.getValue(), (String)child.getKey());
            }
        } else if (propertyValueHolder.isArray()) {
            ArrayNode arrayNode = (ArrayNode)propertyValueHolder;
            if (((JsonNode)arrayNode.elements().next()).isObject() || ((JsonNode)arrayNode.elements().next()).isArray()) {
                Iterator arrayIterator = arrayNode.elements();
                while (arrayIterator.hasNext()) {
                    JsonNode nodeInArray = (JsonNode)arrayIterator.next();
                    if (nodeInArray.isArray()) {
                        this.encryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)null), nodeInArray, "");
                        continue;
                    }
                    Iterator it = nodeInArray.fields();
                    while (it.hasNext()) {
                        Map.Entry child = (Map.Entry)it.next();
                        if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                            this.encryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)nodeInArray), (JsonNode)child.getValue(), propertyName);
                            continue;
                        }
                        if (((JsonNode)child.getValue()).isNull()) continue;
                        this.encryptAndSerializeValue(encryptionSettings, (ObjectNode)nodeInArray, (JsonNode)child.getValue(), (String)child.getKey());
                    }
                }
            } else {
                ArrayList<byte[]> encryptedArray = new ArrayList<byte[]>();
                Iterator it = arrayNode.elements();
                while (it.hasNext()) {
                    encryptedArray.add(this.encryptAndSerializeValue(encryptionSettings, null, (JsonNode)it.next(), ""));
                }
                arrayNode.removeAll();
                for (byte[] encryptedValue : encryptedArray) {
                    arrayNode.add(encryptedValue);
                }
            }
        } else {
            this.encryptAndSerializeValue(encryptionSettings, (ObjectNode)objectNode, propertyValueHolder, propertyName);
        }
    }

    public byte[] encryptAndSerializeValue(EncryptionSettings encryptionSettings, ObjectNode objectNode, JsonNode propertyValueHolder, String propertyName) throws MicrosoftDataEncryptionException {
        Pair<TypeMarker, byte[]> typeMarkerPair = EncryptionProcessor.toByteArray(propertyValueHolder);
        byte[] cipherText = encryptionSettings.getAeadAes256CbcHmac256EncryptionAlgorithm().encrypt((byte[])typeMarkerPair.getRight());
        byte[] cipherTextWithTypeMarker = new byte[cipherText.length + 1];
        cipherTextWithTypeMarker[0] = (byte)((TypeMarker)((Object)typeMarkerPair.getLeft())).getValue();
        System.arraycopy(cipherText, 0, cipherTextWithTypeMarker, 1, cipherText.length);
        if (objectNode != null && !objectNode.isNull()) {
            objectNode.put(propertyName, cipherTextWithTypeMarker);
        }
        return cipherTextWithTypeMarker;
    }

    public Mono<byte[]> decrypt(byte[] input) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encrypting byte[] of size [{}] on thread [{}]", (Object)(input == null ? null : Integer.valueOf(input.length)), (Object)Thread.currentThread().getName());
        }
        if (input == null || input.length == 0) {
            return Mono.empty();
        }
        ObjectNode itemJObj = (ObjectNode)Utils.parse((byte[])input, ObjectNode.class);
        return this.decrypt((JsonNode)itemJObj);
    }

    public Mono<byte[]> decrypt(JsonNode itemJObj) {
        return this.decryptJsonNode(itemJObj).map(decryptedObjectNode -> EncryptionUtils.serializeJsonToByteArray(EncryptionUtils.getSimpleObjectMapper(), decryptedObjectNode));
    }

    public Mono<JsonNode> decryptJsonNode(JsonNode itemJObj) {
        assert (itemJObj != null);
        if (itemJObj.isValueNode()) {
            return Mono.just((Object)itemJObj);
        }
        return this.initEncryptionSettingsIfNotInitializedAsync().then(Mono.defer(() -> {
            for (Object includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                if (!StringUtils.isEmpty((CharSequence)includedPath.getPath()) && includedPath.getPath().charAt(0) == '/' && includedPath.getPath().lastIndexOf(47) == 0) continue;
                return Mono.error((Throwable)new IllegalArgumentException("Invalid encryption path: " + includedPath.getPath()));
            }
            ArrayList<Mono> encryptionMonoList = new ArrayList<Mono>();
            for (ClientEncryptionIncludedPath includedPath : this.clientEncryptionPolicy.getIncludedPaths()) {
                String propertyName = includedPath.getPath().substring(1);
                JsonNode propertyValueHolder = itemJObj.get(propertyName);
                if (propertyValueHolder == null || propertyValueHolder.isNull()) continue;
                Mono voidMono = this.encryptionSettings.getEncryptionSettingForPropertyAsync(propertyName, this).flatMap(settings -> {
                    try {
                        this.decryptAndSerializeProperty((EncryptionSettings)settings, itemJObj, propertyValueHolder, propertyName);
                    }
                    catch (MicrosoftDataEncryptionException | JsonProcessingException ex) {
                        return Mono.error((Throwable)ex);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return Mono.empty();
                });
                encryptionMonoList.add(voidMono);
            }
            Mono listMono = Flux.mergeSequential(encryptionMonoList).collectList();
            return listMono.map(aVoid -> itemJObj);
        }));
    }

    public void decryptAndSerializeProperty(EncryptionSettings encryptionSettings, JsonNode objectNode, JsonNode propertyValueHolder, String propertyName) throws MicrosoftDataEncryptionException, IOException {
        if (propertyValueHolder.isObject()) {
            Iterator it = propertyValueHolder.fields();
            while (it.hasNext()) {
                Map.Entry child = (Map.Entry)it.next();
                if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                    this.decryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)propertyValueHolder), (JsonNode)child.getValue(), propertyName);
                    continue;
                }
                if (((JsonNode)child.getValue()).isNull()) continue;
                this.decryptAndSerializeValue(encryptionSettings, (ObjectNode)propertyValueHolder, (JsonNode)child.getValue(), (String)child.getKey());
            }
        } else if (propertyValueHolder.isArray()) {
            ArrayNode arrayNode = (ArrayNode)propertyValueHolder;
            if (((JsonNode)arrayNode.elements().next()).isObject() || ((JsonNode)arrayNode.elements().next()).isArray()) {
                Iterator arrayIterator = arrayNode.elements();
                while (arrayIterator.hasNext()) {
                    JsonNode nodeInArray = (JsonNode)arrayIterator.next();
                    if (nodeInArray.isArray()) {
                        this.decryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)null), nodeInArray, "");
                        continue;
                    }
                    Iterator it = nodeInArray.fields();
                    while (it.hasNext()) {
                        Map.Entry child = (Map.Entry)it.next();
                        if (((JsonNode)child.getValue()).isObject() || ((JsonNode)child.getValue()).isArray()) {
                            this.decryptAndSerializeProperty(encryptionSettings, (JsonNode)((ObjectNode)nodeInArray), (JsonNode)child.getValue(), propertyName);
                            continue;
                        }
                        if (((JsonNode)child.getValue()).isNull()) continue;
                        this.decryptAndSerializeValue(encryptionSettings, (ObjectNode)nodeInArray, (JsonNode)child.getValue(), (String)child.getKey());
                    }
                }
            } else {
                ArrayList<JsonNode> decryptedArray = new ArrayList<JsonNode>();
                Iterator it = arrayNode.elements();
                while (it.hasNext()) {
                    decryptedArray.add(this.decryptAndSerializeValue(encryptionSettings, null, (JsonNode)it.next(), ""));
                }
                arrayNode.removeAll();
                for (JsonNode encryptedValue : decryptedArray) {
                    arrayNode.add(encryptedValue);
                }
            }
        } else {
            this.decryptAndSerializeValue(encryptionSettings, (ObjectNode)objectNode, propertyValueHolder, propertyName);
        }
    }

    public JsonNode decryptAndSerializeValue(EncryptionSettings encryptionSettings, ObjectNode objectNode, JsonNode propertyValueHolder, String propertyName) throws MicrosoftDataEncryptionException, IOException {
        byte[] cipherTextWithTypeMarker = propertyValueHolder.binaryValue();
        byte[] cipherText = new byte[cipherTextWithTypeMarker.length - 1];
        System.arraycopy(cipherTextWithTypeMarker, 1, cipherText, 0, cipherTextWithTypeMarker.length - 1);
        byte[] plainText = encryptionSettings.getAeadAes256CbcHmac256EncryptionAlgorithm().decrypt(cipherText);
        if (objectNode != null && !objectNode.isNull()) {
            objectNode.set(propertyName, EncryptionProcessor.toJsonNode(plainText, TypeMarker.valueOf(cipherTextWithTypeMarker[0]).get()));
        }
        return EncryptionProcessor.toJsonNode(plainText, TypeMarker.valueOf(cipherTextWithTypeMarker[0]).get());
    }

    public static Pair<TypeMarker, byte[]> toByteArray(JsonNode jsonNode) {
        try {
            SqlSerializerFactory sqlSerializerFactory = new SqlSerializerFactory();
            switch (jsonNode.getNodeType()) {
                case BOOLEAN: {
                    return Pair.of((Object)((Object)TypeMarker.BOOLEAN), (Object)sqlSerializerFactory.getDefaultSerializer(Boolean.class).serialize(jsonNode.asBoolean()));
                }
                case NUMBER: {
                    if (jsonNode.isInt() || jsonNode.isLong()) {
                        return Pair.of((Object)((Object)TypeMarker.LONG), (Object)sqlSerializerFactory.getDefaultSerializer(Long.class).serialize(jsonNode.asLong()));
                    }
                    if (!jsonNode.isFloat() && !jsonNode.isDouble()) break;
                    return Pair.of((Object)((Object)TypeMarker.DOUBLE), (Object)sqlSerializerFactory.getDefaultSerializer(Double.class).serialize(jsonNode.asDouble()));
                }
                case STRING: {
                    return Pair.of((Object)((Object)TypeMarker.STRING), (Object)SqlSerializerFactory.getOrCreate("varchar", -1, 0, 0, StandardCharsets.UTF_8.toString()).serialize(jsonNode.asText()));
                }
            }
        }
        catch (MicrosoftDataEncryptionException ex) {
            throw BridgeInternal.createCosmosException((String)"Unable to convert JSON to byte[]", (Exception)ex, null, (int)0, null);
        }
        throw BridgeInternal.createCosmosException((int)0, (String)("Invalid or Unsupported Data Type Passed " + jsonNode.getNodeType()));
    }

    public static JsonNode toJsonNode(byte[] serializedBytes, TypeMarker typeMarker) {
        try {
            SqlSerializerFactory sqlSerializerFactory = new SqlSerializerFactory();
            switch (typeMarker) {
                case BOOLEAN: {
                    return BooleanNode.valueOf((boolean)((Boolean)sqlSerializerFactory.getDefaultSerializer(Boolean.class).deserialize(serializedBytes)));
                }
                case LONG: {
                    return LongNode.valueOf((long)((Long)sqlSerializerFactory.getDefaultSerializer(Long.class).deserialize(serializedBytes)));
                }
                case DOUBLE: {
                    return DoubleNode.valueOf((double)((Double)sqlSerializerFactory.getDefaultSerializer(Double.class).deserialize(serializedBytes)));
                }
                case STRING: {
                    return TextNode.valueOf((String)((String)SqlSerializerFactory.getOrCreate("varchar", -1, 0, 0, StandardCharsets.UTF_8.toString()).deserialize(serializedBytes)));
                }
            }
        }
        catch (MicrosoftDataEncryptionException ex) {
            throw BridgeInternal.createCosmosException((String)"Unable to convert byte[] to JSON", (Exception)ex, null, (int)0, null);
        }
        throw BridgeInternal.createCosmosException((int)0, (String)("Invalid or Unsupported Data Type Passed " + (Object)((Object)typeMarker)));
    }

    public String getContainerRid() {
        return this.containerRid;
    }

    public AtomicBoolean getIsEncryptionSettingsInitDone() {
        return this.isEncryptionSettingsInitDone;
    }

    EncryptionKeyStoreProviderImpl getEncryptionKeyStoreProviderImpl() {
        return this.encryptionKeyStoreProviderImpl;
    }

    public static enum TypeMarker {
        NULL(1),
        BOOLEAN(2),
        DOUBLE(3),
        LONG(4),
        STRING(5);

        private final int value;

        public static Optional<TypeMarker> valueOf(int value) {
            return Arrays.stream(TypeMarker.values()).filter(legNo -> legNo.value == value).findFirst();
        }

        private TypeMarker(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

