/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.implementation.CosmosResponseFactory;
import com.azure.cosmos.encryption.implementation.EncryptionImplementationBridgeHelpers;
import com.azure.cosmos.encryption.implementation.EncryptionProcessor;
import com.azure.cosmos.encryption.implementation.EncryptionUtils;
import com.azure.cosmos.encryption.models.SqlQuerySpecWithEncryption;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.patch.PatchOperationCore;
import com.azure.cosmos.implementation.patch.PatchOperationType;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.Transformer;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkItemResponse;
import com.azure.cosmos.models.CosmosBulkOperationResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class CosmosEncryptionAsyncContainer {
    private final Scheduler encryptionScheduler;
    private final CosmosResponseFactory responseFactory = new CosmosResponseFactory();
    private final CosmosAsyncContainer container;
    private final EncryptionProcessor encryptionProcessor;
    private final CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient;
    private static final ImplementationBridgeHelpers.CosmosItemResponseHelper.CosmosItemResponseBuilderAccessor cosmosItemResponseBuilderAccessor = ImplementationBridgeHelpers.CosmosItemResponseHelper.getCosmosItemResponseBuilderAccessor();
    private static final ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.CosmosItemRequestOptionsAccessor cosmosItemRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.getCosmosItemRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor cosmosQueryRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.CosmosChangeFeedRequestOptionsAccessor cosmosChangeFeedRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosChangeFeedRequestOptionsHelper.getCosmosChangeFeedRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosAsyncContainerHelper.CosmosAsyncContainerAccessor cosmosAsyncContainerAccessor = ImplementationBridgeHelpers.CosmosAsyncContainerHelper.getCosmosAsyncContainerAccessor();
    private static final ImplementationBridgeHelpers.CosmosBatchHelper.CosmosBatchAccessor cosmosBatchAccessor = ImplementationBridgeHelpers.CosmosBatchHelper.getCosmosBatchAccessor();
    private static final ImplementationBridgeHelpers.CosmosBatchResponseHelper.CosmosBatchResponseAccessor cosmosBatchResponseAccessor = ImplementationBridgeHelpers.CosmosBatchResponseHelper.getCosmosBatchResponseAccessor();
    private static final ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.CosmosBatchOperationResultAccessor cosmosBatchOperationResultAccessor = ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.getCosmosBatchOperationResultAccessor();
    private static final ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.CosmosBatchRequestOptionsAccessor cosmosBatchRequestOptionsAccessor = ImplementationBridgeHelpers.CosmosBatchRequestOptionsHelper.getCosmosBatchRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosPatchOperationsHelper.CosmosPatchOperationsAccessor cosmosPatchOperationsAccessor = ImplementationBridgeHelpers.CosmosPatchOperationsHelper.getCosmosPatchOperationsAccessor();
    private static final ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.CosmosBulkExecutionOptionsAccessor cosmosBulkExecutionOptionsAccessor = ImplementationBridgeHelpers.CosmosBulkExecutionOptionsHelper.getCosmosBulkExecutionOptionsAccessor();
    private static final ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.CosmosBulkItemResponseAccessor cosmosBulkItemResponseAccessor = ImplementationBridgeHelpers.CosmosBulkItemResponseHelper.getCosmosBulkItemResponseAccessor();
    private static final EncryptionImplementationBridgeHelpers.SqlQuerySpecWithEncryptionHelper.SqlQuerySpecWithEncryptionAccessor specWithEncryptionAccessor = EncryptionImplementationBridgeHelpers.SqlQuerySpecWithEncryptionHelper.getSqlQuerySpecWithEncryptionAccessor();

    CosmosEncryptionAsyncContainer(CosmosAsyncContainer container, CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient) {
        this.container = container;
        this.cosmosEncryptionAsyncClient = cosmosEncryptionAsyncClient;
        this.encryptionProcessor = new EncryptionProcessor(this.container, cosmosEncryptionAsyncClient);
        this.encryptionScheduler = Schedulers.parallel();
    }

    EncryptionProcessor getEncryptionProcessor() {
        return this.encryptionProcessor;
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, CosmosItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, (Object)"item");
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        byte[] streamPayload = this.cosmosSerializerToStream(item);
        return this.createItemHelper(streamPayload, null, requestOptions, item.getClass(), false);
    }

    public <T> Mono<CosmosItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, (Object)"item");
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (Object)"partitionKey cannot be null for operations using EncryptionContainer.");
        byte[] streamPayload = this.cosmosSerializerToStream(item);
        return this.createItemHelper(streamPayload, partitionKey, requestOptions, item.getClass(), false);
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse<Object>> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return this.container.deleteItem(itemId, partitionKey, requestOptions);
    }

    public <T> Mono<CosmosItemResponse<Object>> deleteItem(T item, CosmosItemRequestOptions requestOptions) {
        return this.container.deleteItem(item, requestOptions);
    }

    Mono<CosmosItemResponse<Object>> deleteAllItemsByPartitionKey(PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        return this.container.deleteAllItemsByPartitionKey(partitionKey, requestOptions);
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, (Object)"item");
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        byte[] streamPayload = this.cosmosSerializerToStream(item);
        return this.upsertItemHelper(streamPayload, null, requestOptions, item.getClass(), false);
    }

    public <T> Mono<CosmosItemResponse<T>> upsertItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, (Object)"item");
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (Object)"partitionKey cannot be null for operations using EncryptionContainer.");
        byte[] streamPayload = this.cosmosSerializerToStream(item);
        return this.upsertItemHelper(streamPayload, partitionKey, requestOptions, item.getClass(), false);
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, (Object)"item");
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (Object)"partitionKey cannot be null for operations using EncryptionContainer.");
        byte[] streamPayload = this.cosmosSerializerToStream(item);
        return this.replaceItemHelper(streamPayload, itemId, partitionKey, requestOptions, item.getClass(), false);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String id, PartitionKey partitionKey, Class<T> classType) {
        return this.readItem(id, partitionKey, ModelBridgeInternal.createCosmosItemRequestOptions((PartitionKey)partitionKey), classType);
    }

    public <T> Mono<CosmosItemResponse<T>> readItem(String id, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Class<T> classType) {
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        Mono<CosmosItemResponse<byte[]>> responseMessageMono = this.readItemHelper(id, partitionKey, requestOptions, false);
        return responseMessageMono.publishOn(this.encryptionScheduler).flatMap(cosmosItemResponse -> this.setByteArrayContent((CosmosItemResponse<byte[]>)cosmosItemResponse, this.encryptionProcessor.decrypt(cosmosItemResponseBuilderAccessor.getByteArrayContent(cosmosItemResponse))).map(bytes -> this.responseFactory.createItemResponse((CosmosItemResponse<byte[]>)cosmosItemResponse, classType)));
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, Class<T> classType) {
        return this.queryItems(new SqlQuerySpec(query), classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(String query, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
        if (requestOptions == null) {
            requestOptions = new CosmosQueryRequestOptions();
        }
        return this.queryItems(new SqlQuerySpec(query), requestOptions, classType);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec querySpec, Class<T> classType) {
        return this.queryItemsHelper(querySpec, new CosmosQueryRequestOptions(), classType, false);
    }

    public <T> CosmosPagedFlux<T> queryItems(SqlQuerySpec query, CosmosQueryRequestOptions requestOptions, Class<T> classType) {
        if (requestOptions == null) {
            requestOptions = new CosmosQueryRequestOptions();
        }
        return this.queryItemsHelper(query, requestOptions, classType, false);
    }

    public <T> CosmosPagedFlux<T> queryItemsOnEncryptedProperties(SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption, CosmosQueryRequestOptions options, Class<T> classType) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        if (specWithEncryptionAccessor.getEncryptionParamMap(sqlQuerySpecWithEncryption).size() > 0) {
            ArrayList<Mono<Void>> encryptionSqlParameterMonoList = new ArrayList<Mono<Void>>();
            for (Map.Entry<String, SqlParameter> entry : specWithEncryptionAccessor.getEncryptionParamMap(sqlQuerySpecWithEncryption).entrySet()) {
                encryptionSqlParameterMonoList.add(specWithEncryptionAccessor.addEncryptionParameterAsync(sqlQuerySpecWithEncryption, entry.getKey(), entry.getValue(), this));
            }
            Mono listMono = Flux.mergeSequential(encryptionSqlParameterMonoList).collectList();
            Mono sqlQuerySpecMono = listMono.flatMap(ignoreVoids -> Mono.just((Object)specWithEncryptionAccessor.getSqlQuerySpec(sqlQuerySpecWithEncryption)));
            return this.queryItemsHelperWithMonoSqlQuerySpec((Mono<SqlQuerySpec>)sqlQuerySpecMono, sqlQuerySpecWithEncryption, options, classType, false);
        }
        return this.queryItemsHelper(specWithEncryptionAccessor.getSqlQuerySpec(sqlQuerySpecWithEncryption), options, classType, false);
    }

    <T> CosmosPagedFlux<T> queryChangeFeed(CosmosChangeFeedRequestOptions options, Class<T> classType) {
        Preconditions.checkNotNull((Object)options, (Object)"Argument 'options' must not be null.");
        Preconditions.checkNotNull(classType, (Object)"Argument 'classType' must not be null.");
        return this.queryChangeFeedHelper(options, classType, false);
    }

    public <T> Mono<CosmosItemResponse<T>> patchItem(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        Preconditions.checkNotNull((Object)itemId, (Object)"expected non-null itemId");
        Preconditions.checkNotNull((Object)partitionKey, (Object)"expected non-null partitionKey for patchItem");
        Preconditions.checkNotNull((Object)cosmosPatchOperations, (Object)"expected non-null cosmosPatchOperations");
        if (options == null) {
            options = new CosmosPatchItemRequestOptions();
        }
        return this.patchItemHelper(itemId, partitionKey, cosmosPatchOperations, options, itemType);
    }

    private <T> Mono<CosmosItemResponse<T>> patchItemHelper(String itemId, PartitionKey partitionKey, CosmosPatchOperations cosmosPatchOperations, CosmosPatchItemRequestOptions options, Class<T> itemType) {
        this.setRequestHeaders((CosmosItemRequestOptions)options);
        ArrayList<Mono> monoList = new ArrayList<Mono>();
        for (PatchOperation patchOperation : cosmosPatchOperationsAccessor.getPatchOperations(cosmosPatchOperations)) {
            Mono itemPatchOperationMono = null;
            if (patchOperation.getOperationType() == PatchOperationType.REMOVE) {
                itemPatchOperationMono = Mono.just((Object)patchOperation);
            } else {
                if (patchOperation.getOperationType() == PatchOperationType.INCREMENT) {
                    throw new IllegalArgumentException("Increment patch operation is not allowed for encrypted path");
                }
                if (patchOperation instanceof PatchOperationCore) {
                    JsonNode objectNode = EncryptionUtils.getSimpleObjectMapper().valueToTree(((PatchOperationCore)patchOperation).getResource());
                    itemPatchOperationMono = this.encryptionProcessor.encryptPatchNode(objectNode, ((PatchOperationCore)patchOperation).getPath()).map(encryptedObjectNode -> new PatchOperationCore(patchOperation.getOperationType(), ((PatchOperationCore)patchOperation).getPath(), encryptedObjectNode));
                }
            }
            monoList.add(itemPatchOperationMono);
        }
        Mono encryptedPatchOperationsListMono = Flux.mergeSequential(monoList).collectList();
        CosmosPatchItemRequestOptions finalRequestOptions = options;
        CosmosPatchOperations encryptedCosmosPatchOperations = CosmosPatchOperations.create();
        return encryptedPatchOperationsListMono.flatMap(patchOperations -> {
            cosmosPatchOperationsAccessor.getPatchOperations(encryptedCosmosPatchOperations).addAll(patchOperations);
            return this.patchItemInternalHelper(itemId, partitionKey, encryptedCosmosPatchOperations, finalRequestOptions, itemType, false);
        });
    }

    private <T> Mono<CosmosItemResponse<T>> patchItemInternalHelper(String itemId, PartitionKey partitionKey, CosmosPatchOperations encryptedCosmosPatchOperations, CosmosPatchItemRequestOptions requestOptions, Class<T> itemType, boolean isRetry) {
        this.setRequestHeaders((CosmosItemRequestOptions)requestOptions);
        return this.container.patchItem(itemId, partitionKey, encryptedCosmosPatchOperations, requestOptions, itemType).publishOn(this.encryptionScheduler).flatMap(cosmosItemResponse -> this.setByteArrayContent((CosmosItemResponse<byte[]>)cosmosItemResponse, this.encryptionProcessor.decrypt(cosmosItemResponseBuilderAccessor.getByteArrayContent(cosmosItemResponse))).map(bytes -> this.responseFactory.createItemResponse((CosmosItemResponse<byte[]>)cosmosItemResponse, itemType))).onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.patchItemInternalHelper(itemId, partitionKey, encryptedCosmosPatchOperations, requestOptions, itemType, true)));
            }
            return Mono.error((Throwable)exception);
        });
    }

    CosmosEncryptionAsyncClient getCosmosEncryptionAsyncClient() {
        return this.cosmosEncryptionAsyncClient;
    }

    public CosmosAsyncContainer getCosmosAsyncContainer() {
        return this.container;
    }

    <T> byte[] cosmosSerializerToStream(T item) {
        return EncryptionUtils.serializeJsonToByteArray(EncryptionUtils.getSimpleObjectMapper(), item);
    }

    ItemDeserializer getItemDeserializer() {
        return CosmosBridgeInternal.getAsyncDocumentClient((CosmosAsyncDatabase)this.container.getDatabase()).getItemDeserializer();
    }

    Mono<JsonNode> decryptResponseNode(JsonNode jsonNode) {
        if (jsonNode == null) {
            return Mono.empty();
        }
        return this.encryptionProcessor.decryptJsonNode(jsonNode);
    }

    private Mono<CosmosItemResponse<byte[]>> setByteArrayContent(CosmosItemResponse<byte[]> rsp, Mono<byte[]> bytesMono) {
        return bytesMono.flatMap(bytes -> {
            cosmosItemResponseBuilderAccessor.setByteArrayContent(rsp, bytes);
            return Mono.just((Object)rsp);
        }).defaultIfEmpty(rsp);
    }

    private <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryDecryptionTransformer(Class<T> classType, boolean isChangeFeed, Function<CosmosPagedFluxOptions, Flux<FeedResponse<JsonNode>>> func) {
        return func.andThen(flux -> flux.publishOn(this.encryptionScheduler).flatMap(page -> {
            boolean useEtagAsContinuation = isChangeFeed;
            boolean isNoChangesResponse = isChangeFeed ? ModelBridgeInternal.getNoCHangesFromFeedResponse((FeedResponse)page) : false;
            List jsonNodeArrayMonoList = page.getResults().stream().map(jsonNode -> this.decryptResponseNode((JsonNode)jsonNode)).collect(Collectors.toList());
            return Flux.concat(jsonNodeArrayMonoList).map(item -> this.getItemDeserializer().convert(classType, item)).collectList().map(itemList -> BridgeInternal.createFeedResponseWithQueryMetrics((List)itemList, (Map)page.getResponseHeaders(), (ConcurrentMap)BridgeInternal.queryMetricsFromFeedResponse((FeedResponse)page), (QueryInfo.QueryPlanDiagnosticsContext)ModelBridgeInternal.getQueryPlanDiagnosticsContext((FeedResponse)page), (boolean)useEtagAsContinuation, (boolean)isNoChangesResponse, (CosmosDiagnostics)page.getCosmosDiagnostics()));
        }));
    }

    private Mono<CosmosItemResponse<byte[]>> readItemHelper(String id, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, boolean isRetry) {
        this.setRequestHeaders(requestOptions);
        Mono responseMessageMono = this.container.readItem(id, partitionKey, requestOptions, byte[].class);
        return responseMessageMono.onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.readItemHelper(id, partitionKey, requestOptions, true)));
            }
            return Mono.error((Throwable)exception);
        });
    }

    private <T> Mono<CosmosItemResponse<T>> createItemHelper(byte[] streamPayload, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Class<T> itemClass, boolean isRetry) {
        this.setRequestHeaders(requestOptions);
        return this.encryptionProcessor.encrypt(streamPayload).flatMap(encryptedPayload -> this.createItemHelper((byte[])encryptedPayload, partitionKey, requestOptions).publishOn(this.encryptionScheduler).flatMap(cosmosItemResponse -> this.setByteArrayContent((CosmosItemResponse<byte[]>)cosmosItemResponse, this.encryptionProcessor.decrypt(cosmosItemResponseBuilderAccessor.getByteArrayContent(cosmosItemResponse))).map(bytes -> this.responseFactory.createItemResponse((CosmosItemResponse<byte[]>)cosmosItemResponse, itemClass))).onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.createItemHelper(streamPayload, partitionKey, requestOptions, itemClass, true)));
            }
            return Mono.error((Throwable)exception);
        }));
    }

    private <T> Mono<CosmosItemResponse<byte[]>> createItemHelper(byte[] encryptedPayload, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return partitionKey != null ? this.container.createItem((Object)encryptedPayload, partitionKey, requestOptions) : this.container.createItem((Object)encryptedPayload, requestOptions);
    }

    private <T> Mono<CosmosItemResponse<T>> upsertItemHelper(byte[] streamPayload, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Class<T> itemClass, boolean isRetry) {
        this.setRequestHeaders(requestOptions);
        return this.encryptionProcessor.encrypt(streamPayload).flatMap(encryptedPayload -> this.upsertItemHelper((byte[])encryptedPayload, partitionKey, requestOptions).publishOn(this.encryptionScheduler).flatMap(cosmosItemResponse -> this.setByteArrayContent((CosmosItemResponse<byte[]>)cosmosItemResponse, this.encryptionProcessor.decrypt(cosmosItemResponseBuilderAccessor.getByteArrayContent(cosmosItemResponse))).map(bytes -> this.responseFactory.createItemResponse((CosmosItemResponse<byte[]>)cosmosItemResponse, itemClass))).onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.upsertItemHelper(streamPayload, partitionKey, requestOptions, itemClass, true)));
            }
            return Mono.error((Throwable)exception);
        }));
    }

    private <T> Mono<CosmosItemResponse<byte[]>> upsertItemHelper(byte[] encryptedPayload, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions) {
        return partitionKey != null ? this.container.upsertItem((Object)encryptedPayload, partitionKey, requestOptions) : this.container.upsertItem((Object)encryptedPayload, requestOptions);
    }

    private <T> Mono<CosmosItemResponse<T>> replaceItemHelper(byte[] streamPayload, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Class<T> itemClass, boolean isRetry) {
        this.setRequestHeaders(requestOptions);
        return this.encryptionProcessor.encrypt(streamPayload).flatMap(encryptedPayload -> this.container.replaceItem(encryptedPayload, itemId, partitionKey, requestOptions).publishOn(this.encryptionScheduler).flatMap(cosmosItemResponse -> this.setByteArrayContent((CosmosItemResponse<byte[]>)cosmosItemResponse, this.encryptionProcessor.decrypt(cosmosItemResponseBuilderAccessor.getByteArrayContent(cosmosItemResponse))).map(bytes -> this.responseFactory.createItemResponse((CosmosItemResponse<byte[]>)cosmosItemResponse, itemClass))).onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.replaceItemHelper(streamPayload, itemId, partitionKey, requestOptions, itemClass, true)));
            }
            return Mono.error((Throwable)exception);
        }));
    }

    private <T> CosmosPagedFlux<T> queryItemsHelper(SqlQuerySpec sqlQuerySpec, CosmosQueryRequestOptions options, final Class<T> classType, boolean isRetry) {
        this.setRequestHeaders(options);
        CosmosQueryRequestOptions finalOptions = options;
        Flux tFlux = CosmosBridgeInternal.queryItemsInternal((CosmosAsyncContainer)this.container, (SqlQuerySpec)sqlQuerySpec, (CosmosQueryRequestOptions)options, (Transformer)new Transformer<T>(){

            public Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> transform(Function<CosmosPagedFluxOptions, Flux<FeedResponse<JsonNode>>> func) {
                return CosmosEncryptionAsyncContainer.this.queryDecryptionTransformer(classType, false, func);
            }
        }).byPage().onErrorResume(exception -> {
            if (exception instanceof CosmosException) {
                CosmosException cosmosException = (CosmosException)exception;
                if (!isRetry && this.isIncorrectContainerRid(cosmosException)) {
                    this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                    return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).thenMany((Publisher)CosmosPagedFlux.defer(() -> this.queryItemsHelper(sqlQuerySpec, finalOptions, classType, true).byPage()));
                }
            }
            return Mono.error((Throwable)exception);
        });
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount((CosmosPagedFluxOptions)pagedFluxOptions, (CosmosQueryRequestOptions)finalOptions);
            return tFlux;
        });
    }

    private <T> CosmosPagedFlux<T> queryChangeFeedHelper(CosmosChangeFeedRequestOptions options, Class<T> classType, boolean isRetry) {
        this.setRequestHeaders(options);
        CosmosChangeFeedRequestOptions finalOptions = options;
        Flux tFlux = UtilBridgeInternal.createCosmosPagedFlux((Function)((Transformer)func -> this.queryDecryptionTransformer(classType, true, func)).transform(cosmosAsyncContainerAccessor.queryChangeFeedInternalFunc(this.container, options, JsonNode.class))).byPage().onErrorResume(exception -> {
            if (exception instanceof CosmosException) {
                CosmosException cosmosException = (CosmosException)exception;
                if (!isRetry && this.isIncorrectContainerRid(cosmosException)) {
                    this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                    return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).thenMany((Publisher)CosmosPagedFlux.defer(() -> this.queryChangeFeedHelper(finalOptions, classType, true).byPage()));
                }
            }
            return Mono.error((Throwable)exception);
        });
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.getEffectiveCosmosChangeFeedRequestOptions((CosmosPagedFluxOptions)pagedFluxOptions, (CosmosChangeFeedRequestOptions)finalOptions);
            return tFlux;
        });
    }

    private <T> CosmosPagedFlux<T> queryItemsHelperWithMonoSqlQuerySpec(Mono<SqlQuerySpec> sqlQuerySpecMono, SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption, CosmosQueryRequestOptions options, final Class<T> classType, boolean isRetry) {
        this.setRequestHeaders(options);
        CosmosQueryRequestOptions finalOptions = options;
        Flux tFlux = CosmosBridgeInternal.queryItemsInternal((CosmosAsyncContainer)this.container, sqlQuerySpecMono, (CosmosQueryRequestOptions)options, (Transformer)new Transformer<T>(){

            public Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> transform(Function<CosmosPagedFluxOptions, Flux<FeedResponse<JsonNode>>> func) {
                return CosmosEncryptionAsyncContainer.this.queryDecryptionTransformer(classType, false, func);
            }
        }).byPage().onErrorResume(exception -> {
            if (exception instanceof CosmosException) {
                CosmosException cosmosException = (CosmosException)exception;
                if (!isRetry && this.isIncorrectContainerRid(cosmosException)) {
                    this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                    return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).thenMany((Publisher)CosmosPagedFlux.defer(() -> this.queryItemsHelper(specWithEncryptionAccessor.getSqlQuerySpec(sqlQuerySpecWithEncryption), finalOptions, classType, true).byPage()));
                }
            }
            return Mono.error((Throwable)exception);
        });
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount((CosmosPagedFluxOptions)pagedFluxOptions, (CosmosQueryRequestOptions)finalOptions);
            return tFlux;
        });
    }

    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch) {
        return this.executeCosmosBatch(cosmosBatch, new CosmosBatchRequestOptions());
    }

    public Mono<CosmosBatchResponse> executeCosmosBatch(CosmosBatch cosmosBatch, CosmosBatchRequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new CosmosBatchRequestOptions();
        }
        ArrayList<Mono> monoList = new ArrayList<Mono>();
        for (ItemBatchOperation itemBatchOperation : cosmosBatchAccessor.getOperationsInternal(cosmosBatch)) {
            Mono itemBatchOperationMono = null;
            if (itemBatchOperation.getItem() != null) {
                ObjectNode objectNode = (ObjectNode)EncryptionUtils.getSimpleObjectMapper().valueToTree(itemBatchOperation.getItem());
                itemBatchOperationMono = this.encryptionProcessor.encryptObjectNode((JsonNode)objectNode).map(encryptedItem -> new ItemBatchOperation(itemBatchOperation.getOperationType(), itemBatchOperation.getId(), itemBatchOperation.getPartitionKeyValue(), itemBatchOperation.getRequestOptions(), encryptedItem));
            } else {
                itemBatchOperationMono = Mono.just((Object)new ItemBatchOperation(itemBatchOperation.getOperationType(), itemBatchOperation.getId(), itemBatchOperation.getPartitionKeyValue(), itemBatchOperation.getRequestOptions(), null));
            }
            monoList.add(itemBatchOperationMono);
        }
        Mono encryptedOperationListMono = Flux.mergeSequential(monoList).collectList();
        CosmosBatchRequestOptions finalRequestOptions = requestOptions;
        CosmosBatch encryptedCosmosBatch = CosmosBatch.createCosmosBatch((PartitionKey)cosmosBatch.getPartitionKeyValue());
        return encryptedOperationListMono.flatMap(itemBatchOperations -> {
            cosmosBatchAccessor.getOperationsInternal(encryptedCosmosBatch).addAll(itemBatchOperations);
            return this.executeCosmosBatchHelper(encryptedCosmosBatch, finalRequestOptions, false);
        });
    }

    private Mono<CosmosBatchResponse> executeCosmosBatchHelper(CosmosBatch encryptedCosmosBatch, CosmosBatchRequestOptions requestOptions, boolean isRetry) {
        this.setRequestHeaders(requestOptions);
        return this.container.executeCosmosBatch(encryptedCosmosBatch, requestOptions).flatMap(cosmosBatchResponse -> {
            if (!isRetry && cosmosBatchResponse.getSubStatusCode() == 1024) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.executeCosmosBatchHelper(encryptedCosmosBatch, requestOptions, true)));
            }
            ArrayList<Mono> decryptMonoList = new ArrayList<Mono>();
            for (CosmosBatchOperationResult cosmosBatchOperationResult : cosmosBatchResponseAccessor.getResults(cosmosBatchResponse)) {
                ObjectNode objectNode = cosmosBatchOperationResultAccessor.getResourceObject(cosmosBatchOperationResult);
                if (objectNode == null) continue;
                decryptMonoList.add(this.encryptionProcessor.decryptJsonNode((JsonNode)objectNode).flatMap(jsonNode -> {
                    cosmosBatchOperationResultAccessor.setResourceObject(cosmosBatchOperationResult, (ObjectNode)jsonNode);
                    return Mono.empty();
                }));
            }
            Mono listMono = Flux.mergeSequential(decryptMonoList).collectList();
            return listMono.map(aVoid -> cosmosBatchResponse);
        }).onErrorResume(exception -> {
            CosmosException cosmosException;
            if (!isRetry && exception instanceof CosmosException && this.isIncorrectContainerRid(cosmosException = (CosmosException)exception)) {
                this.encryptionProcessor.getIsEncryptionSettingsInitDone().set(false);
                return this.encryptionProcessor.initializeEncryptionSettingsAsync(true).then(Mono.defer(() -> this.executeCosmosBatchHelper(encryptedCosmosBatch, requestOptions, true)));
            }
            return Mono.error((Throwable)exception);
        });
    }

    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<CosmosItemOperation> operations) {
        return this.executeBulkOperations(operations, new CosmosBulkExecutionOptions());
    }

    public <TContext> Flux<CosmosBulkOperationResponse<TContext>> executeBulkOperations(Flux<CosmosItemOperation> operations, CosmosBulkExecutionOptions bulkOptions) {
        if (bulkOptions == null) {
            bulkOptions = new CosmosBulkExecutionOptions();
        }
        CosmosBulkExecutionOptions cosmosBulkExecutionOptions = bulkOptions;
        Flux operationFlux = operations.flatMap(cosmosItemOperation -> {
            Mono cosmosItemOperationMono;
            if (cosmosItemOperation.getItem() != null) {
                ObjectNode objectNode = (ObjectNode)EncryptionUtils.getSimpleObjectMapper().valueToTree(cosmosItemOperation.getItem());
                assert (cosmosItemOperation instanceof ItemBulkOperation);
                cosmosItemOperationMono = this.encryptionProcessor.encryptObjectNode((JsonNode)objectNode).map(encryptedItem -> new ItemBulkOperation(cosmosItemOperation.getOperationType(), cosmosItemOperation.getId(), cosmosItemOperation.getPartitionKeyValue(), ((ItemBulkOperation)cosmosItemOperation).getRequestOptions(), encryptedItem, cosmosItemOperation.getContext()));
            } else {
                cosmosItemOperationMono = Mono.just((Object)new ItemBulkOperation(cosmosItemOperation.getOperationType(), cosmosItemOperation.getId(), cosmosItemOperation.getPartitionKeyValue(), ((ItemBulkOperation)cosmosItemOperation).getRequestOptions(), null, cosmosItemOperation.getContext()));
            }
            return cosmosItemOperationMono;
        });
        Mono listMono = operationFlux.collectList();
        this.setRequestHeaders(cosmosBulkExecutionOptions);
        operationFlux = listMono.flatMapMany(Flux::fromIterable);
        return this.executeBulkOperationsHelper((Flux<CosmosItemOperation>)operationFlux, cosmosBulkExecutionOptions, false);
    }

    private <TContext> Flux<CosmosBulkOperationResponse<TContext>> executeBulkOperationsHelper(Flux<CosmosItemOperation> operations, CosmosBulkExecutionOptions bulkOptions, boolean isRetry) {
        return this.container.executeBulkOperations(operations, bulkOptions).flatMap(cosmosBulkOperationResponse -> {
            CosmosBulkItemResponse cosmosBulkItemResponse = cosmosBulkOperationResponse.getResponse();
            ObjectNode objectNode = cosmosBulkItemResponseAccessor.getResourceObject(cosmosBulkItemResponse);
            if (objectNode != null) {
                Mono jsonNodeMono = this.encryptionProcessor.decryptJsonNode((JsonNode)objectNode).flatMap(jsonNode -> {
                    cosmosBulkItemResponseAccessor.setResourceObject(cosmosBulkItemResponse, (ObjectNode)jsonNode);
                    return Mono.just((Object)jsonNode);
                });
                return jsonNodeMono.flux().flatMap(jsonNode -> Flux.just((Object)cosmosBulkOperationResponse));
            }
            return Mono.just((Object)cosmosBulkOperationResponse);
        });
    }

    private void setRequestHeaders(CosmosItemRequestOptions requestOptions) {
        cosmosItemRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-is-client-encrypted", "true");
        cosmosItemRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-intended-collection-rid", this.encryptionProcessor.getContainerRid());
    }

    private void setRequestHeaders(CosmosQueryRequestOptions requestOptions) {
        cosmosQueryRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-is-client-encrypted", "true");
        cosmosQueryRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-intended-collection-rid", this.encryptionProcessor.getContainerRid());
    }

    private void setRequestHeaders(CosmosChangeFeedRequestOptions requestOptions) {
        cosmosChangeFeedRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-is-client-encrypted", "true");
        cosmosChangeFeedRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-intended-collection-rid", this.encryptionProcessor.getContainerRid());
    }

    private void setRequestHeaders(CosmosBatchRequestOptions requestOptions) {
        cosmosBatchRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-is-client-encrypted", "true");
        cosmosBatchRequestOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-intended-collection-rid", this.encryptionProcessor.getContainerRid());
    }

    private void setRequestHeaders(CosmosBulkExecutionOptions requestOptions) {
        cosmosBulkExecutionOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-is-client-encrypted", "true");
        cosmosBulkExecutionOptionsAccessor.setHeader(requestOptions, "x-ms-cosmos-intended-collection-rid", this.encryptionProcessor.getContainerRid());
    }

    boolean isIncorrectContainerRid(CosmosException cosmosException) {
        return cosmosException.getStatusCode() == 400 && ((String)cosmosException.getResponseHeaders().get("x-ms-substatus")).equals("1024");
    }

    static {
        EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncContainerHelper.setCosmosEncryptionAsyncContainerAccessor(new EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncContainerHelper.CosmosEncryptionAsyncContainerAccessor(){

            @Override
            public EncryptionProcessor getEncryptionProcessor(CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer) {
                return cosmosEncryptionAsyncContainer.getEncryptionProcessor();
            }
        });
    }
}

