/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncClientEncryptionKey;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncDatabase;
import com.azure.cosmos.encryption.CosmosEncryptionClientBuilder;
import com.azure.cosmos.encryption.implementation.EncryptionImplementationBridgeHelpers;
import com.azure.cosmos.encryption.implementation.keyprovider.EncryptionKeyStoreProviderImpl;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerResponse;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CosmosEncryptionClientBuilder.class, isAsync=true)
public final class CosmosEncryptionAsyncClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosEncryptionAsyncClient.class);
    private final CosmosAsyncClient cosmosAsyncClient;
    private final AsyncCache<String, CosmosContainerProperties> containerPropertiesCacheByContainerId;
    private final AsyncCache<String, CosmosClientEncryptionKeyProperties> clientEncryptionKeyPropertiesCacheByKeyId;
    private final KeyEncryptionKeyResolver keyEncryptionKeyResolver;
    private final String keyEncryptionKeyResolverName;
    private final EncryptionKeyStoreProviderImpl encryptionKeyStoreProviderImpl;
    private static final ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.CosmosAsyncClientEncryptionKeyAccessor cosmosAsyncClientEncryptionKeyAccessor = ImplementationBridgeHelpers.CosmosAsyncClientEncryptionKeyHelper.getCosmosAsyncClientEncryptionKeyAccessor();

    CosmosEncryptionAsyncClient(CosmosAsyncClient cosmosAsyncClient, KeyEncryptionKeyResolver keyEncryptionKeyResolver, String keyEncryptionKeyResolverName) {
        if (cosmosAsyncClient == null) {
            throw new IllegalArgumentException("cosmosClient is null");
        }
        if (keyEncryptionKeyResolver == null) {
            throw new IllegalArgumentException("keyEncryptionKeyResolver is null");
        }
        if (StringUtils.isEmpty((CharSequence)keyEncryptionKeyResolverName)) {
            throw new IllegalArgumentException("keyEncryptionKeyResolverName is null");
        }
        this.cosmosAsyncClient = cosmosAsyncClient;
        this.keyEncryptionKeyResolver = keyEncryptionKeyResolver;
        this.clientEncryptionKeyPropertiesCacheByKeyId = new AsyncCache();
        this.containerPropertiesCacheByContainerId = new AsyncCache();
        this.keyEncryptionKeyResolverName = keyEncryptionKeyResolverName;
        this.encryptionKeyStoreProviderImpl = new EncryptionKeyStoreProviderImpl(keyEncryptionKeyResolver, keyEncryptionKeyResolverName);
    }

    public KeyEncryptionKeyResolver getKeyEncryptionKeyResolver() {
        return this.keyEncryptionKeyResolver;
    }

    public String getKeyEncryptionKeyResolverName() {
        return this.keyEncryptionKeyResolverName;
    }

    EncryptionKeyStoreProviderImpl getEncryptionKeyStoreProviderImpl() {
        return this.encryptionKeyStoreProviderImpl;
    }

    Mono<CosmosContainerProperties> getContainerPropertiesAsync(CosmosAsyncContainer container, boolean shouldForceRefresh) {
        String cacheKey = container.getDatabase().getId() + "/" + container.getId();
        if (!shouldForceRefresh) {
            return this.containerPropertiesCacheByContainerId.getAsync((Object)cacheKey, null, () -> container.read().map(cosmosContainerResponse -> this.getContainerPropertiesWithVersionValidation((CosmosContainerResponse)cosmosContainerResponse)));
        }
        return this.containerPropertiesCacheByContainerId.getAsync((Object)cacheKey, null, () -> container.read().map(cosmosContainerResponse -> this.getContainerPropertiesWithVersionValidation((CosmosContainerResponse)cosmosContainerResponse))).flatMap(clientEncryptionPolicy -> this.containerPropertiesCacheByContainerId.getAsync((Object)cacheKey, clientEncryptionPolicy, () -> container.read().map(cosmosContainerResponse -> this.getContainerPropertiesWithVersionValidation((CosmosContainerResponse)cosmosContainerResponse))));
    }

    Mono<CosmosClientEncryptionKeyProperties> getClientEncryptionPropertiesAsync(String clientEncryptionKeyId, String databaseRid, CosmosAsyncContainer cosmosAsyncContainer, boolean shouldForceRefresh, String ifNoneMatchEtag, boolean shouldForceRefreshGateway) {
        String cacheKey = databaseRid + "/" + clientEncryptionKeyId;
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHeader("x-ms-cosmos-allow-cachedreads", String.valueOf(true));
        requestOptions.setHeader("x-ms-cosmos-database-rid", databaseRid);
        if (StringUtils.isNotEmpty((CharSequence)ifNoneMatchEtag)) {
            requestOptions.setIfNoneMatchETag(ifNoneMatchEtag);
        }
        if (!shouldForceRefresh && !shouldForceRefreshGateway) {
            return this.clientEncryptionKeyPropertiesCacheByKeyId.getAsync((Object)cacheKey, null, () -> this.fetchClientEncryptionKeyPropertiesAsync(cosmosAsyncContainer, clientEncryptionKeyId, requestOptions));
        }
        return this.clientEncryptionKeyPropertiesCacheByKeyId.getAsync((Object)cacheKey, null, () -> this.fetchClientEncryptionKeyPropertiesAsync(cosmosAsyncContainer, clientEncryptionKeyId, requestOptions)).flatMap(cachedClientEncryptionProperties -> this.clientEncryptionKeyPropertiesCacheByKeyId.getAsync((Object)cacheKey, cachedClientEncryptionProperties, () -> this.fetchClientEncryptionKeyPropertiesAsync(cosmosAsyncContainer, clientEncryptionKeyId, requestOptions)));
    }

    Mono<CosmosClientEncryptionKeyProperties> fetchClientEncryptionKeyPropertiesAsync(CosmosAsyncContainer container, String clientEncryptionKeyId, RequestOptions requestOptions) {
        CosmosAsyncClientEncryptionKey clientEncryptionKey = container.getDatabase().getClientEncryptionKey(clientEncryptionKeyId);
        return cosmosAsyncClientEncryptionKeyAccessor.readClientEncryptionKey(clientEncryptionKey, requestOptions).map(cosmosClientEncryptionKeyResponse -> cosmosClientEncryptionKeyResponse.getProperties()).onErrorResume(throwable -> {
            if (!(throwable instanceof Exception)) {
                LOGGER.error("Unexpected failure {}", (Object)throwable.getMessage(), throwable);
                return Mono.error((Throwable)throwable);
            }
            Exception exception = (Exception)throwable;
            CosmosException dce = (CosmosException)Utils.as((Object)exception, CosmosException.class);
            if (dce != null) {
                if (dce.getStatusCode() == 404) {
                    String message = "Encryption Based Container without Data Encryption Keys. Please make sure you have created the Client Encryption Keys";
                    return Mono.error((Throwable)BridgeInternal.createCosmosException((int)404, (String)message));
                }
                return Mono.error((Throwable)dce);
            }
            return Mono.error((Throwable)exception);
        });
    }

    public CosmosAsyncClient getCosmosAsyncClient() {
        return this.cosmosAsyncClient;
    }

    public CosmosEncryptionAsyncDatabase getCosmosEncryptionAsyncDatabase(CosmosAsyncDatabase cosmosAsyncDatabase) {
        return new CosmosEncryptionAsyncDatabase(cosmosAsyncDatabase, this);
    }

    public CosmosEncryptionAsyncDatabase getCosmosEncryptionAsyncDatabase(String databaseId) {
        CosmosAsyncDatabase database = this.cosmosAsyncClient.getDatabase(databaseId);
        return new CosmosEncryptionAsyncDatabase(database, this);
    }

    @Override
    public void close() {
        this.cosmosAsyncClient.close();
    }

    private CosmosContainerProperties getContainerPropertiesWithVersionValidation(CosmosContainerResponse cosmosContainerResponse) {
        if (cosmosContainerResponse.getProperties().getClientEncryptionPolicy() == null) {
            throw new IllegalArgumentException("Container without client encryption policy cannot be used");
        }
        if (cosmosContainerResponse.getProperties().getClientEncryptionPolicy().getPolicyFormatVersion() > 1) {
            throw new UnsupportedOperationException("This version of the Encryption library cannot be used with this container. Please upgrade to the latest version of the same.");
        }
        return cosmosContainerResponse.getProperties();
    }

    static {
        EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.seCosmosEncryptionAsyncClientAccessor(new EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.CosmosEncryptionAsyncClientAccessor(){

            @Override
            public Mono<CosmosClientEncryptionKeyProperties> getClientEncryptionPropertiesAsync(CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient, String clientEncryptionKeyId, String databaseRid, CosmosAsyncContainer cosmosAsyncContainer, boolean shouldForceRefresh, String ifNoneMatchEtag, boolean shouldForceRefreshGateway) {
                return cosmosEncryptionAsyncClient.getClientEncryptionPropertiesAsync(clientEncryptionKeyId, databaseRid, cosmosAsyncContainer, shouldForceRefresh, ifNoneMatchEtag, shouldForceRefreshGateway);
            }

            @Override
            public Mono<CosmosContainerProperties> getContainerPropertiesAsync(CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient, CosmosAsyncContainer cosmosAsyncContainer, boolean shouldForceRefresh) {
                return cosmosEncryptionAsyncClient.getContainerPropertiesAsync(cosmosAsyncContainer, shouldForceRefresh);
            }

            @Override
            public EncryptionKeyStoreProviderImpl getEncryptionKeyStoreProviderImpl(CosmosEncryptionAsyncClient cosmosEncryptionAsyncClient) {
                return cosmosEncryptionAsyncClient.getEncryptionKeyStoreProviderImpl();
            }
        });
    }
}

