/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ResponseConstructorsCache {
    private static final String THREE_PARAM_ERROR = "Failed to deserialize 3-parameter response.";
    private static final String FOUR_PARAM_ERROR = "Failed to deserialize 4-parameter response.";
    private static final String FIVE_PARAM_ERROR = "Failed to deserialize 5-parameter response.";
    private static final String INVALID_PARAM_COUNT = "Response constructor with expected parameters not found.";
    private static final Map<Class<?>, MethodHandle> CACHE = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ResponseConstructorsCache.class);

    public MethodHandle get(Class<? extends Response<?>> responseClass) {
        return CACHE.computeIfAbsent(responseClass, ResponseConstructorsCache::locateResponseConstructor);
    }

    private static MethodHandle locateResponseConstructor(Class<?> responseClass) {
        MethodHandles.Lookup lookupToUse;
        try {
            lookupToUse = ReflectionUtils.getLookupToUse(responseClass);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)ex);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(ex));
        }
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                return lookupToUse.unreflectConstructor(constructor);
            }
            catch (IllegalAccessException ex) {
                throw LOGGER.logExceptionAsError(new RuntimeException(ex));
            }
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Cannot find suitable constructor for class " + responseClass));
    }

    public Response<?> invoke(MethodHandle handle, HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
        HttpResponse httpResponse = decodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int responseStatusCode = httpResponse.getStatusCode();
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        int paramCount = handle.type().parameterCount();
        switch (paramCount) {
            case 3: {
                return ResponseConstructorsCache.constructResponse(handle, THREE_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders);
            }
            case 4: {
                return ResponseConstructorsCache.constructResponse(handle, FOUR_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders, bodyAsObject);
            }
            case 5: {
                return ResponseConstructorsCache.constructResponse(handle, FIVE_PARAM_ERROR, httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedResponse.getDecodedHeaders());
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(INVALID_PARAM_COUNT));
    }

    private static Response<?> constructResponse(MethodHandle handle, String exceptionMessage, Object ... params) {
        try {
            return (Response)handle.invokeWithArguments(params);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)throwable);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException(exceptionMessage, throwable));
        }
    }
}

