/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.UrlToken;
import com.azure.core.util.UrlTokenizerState;

class UrlTokenizer {
    private final String text;
    private final int textLength;
    private UrlTokenizerState state;
    private int currentIndex;
    private UrlToken currentToken;

    UrlTokenizer(String text) {
        this(text, UrlTokenizerState.SCHEME_OR_HOST);
    }

    UrlTokenizer(String text, UrlTokenizerState state) {
        this.text = text;
        this.textLength = text == null ? 0 : text.length();
        this.state = state;
        this.currentIndex = 0;
        this.currentToken = null;
    }

    private boolean hasCurrentCharacter() {
        return this.currentIndex < this.textLength;
    }

    private char currentCharacter() {
        return this.text.charAt(this.currentIndex);
    }

    private void nextCharacter() {
        this.nextCharacter(1);
    }

    private void nextCharacter(int step) {
        if (this.hasCurrentCharacter()) {
            this.currentIndex += step;
        }
    }

    private boolean peekMatchesSchemeSeparator() {
        return "://".regionMatches(0, this.text, this.currentIndex, 3);
    }

    UrlToken current() {
        return this.currentToken;
    }

    boolean next() {
        if (!this.hasCurrentCharacter()) {
            this.currentToken = null;
        } else {
            switch (this.state) {
                case SCHEME: {
                    String scheme = this.readUntilNotLetterOrDigit();
                    this.currentToken = UrlToken.scheme(scheme);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.HOST;
                    break;
                }
                case SCHEME_OR_HOST: {
                    String schemeOrHost = this.readUntilCharacter(':', '/', '?');
                    if (!this.hasCurrentCharacter()) {
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == ':') {
                        if (this.peekMatchesSchemeSeparator()) {
                            this.currentToken = UrlToken.scheme(schemeOrHost);
                            this.state = UrlTokenizerState.HOST;
                            break;
                        }
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.currentToken = UrlToken.host(schemeOrHost);
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    if (this.currentCharacter() != '?') break;
                    this.currentToken = UrlToken.host(schemeOrHost);
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case HOST: {
                    if (this.peekMatchesSchemeSeparator()) {
                        this.nextCharacter(3);
                    }
                    String host = this.readUntilCharacter(':', '/', '?');
                    this.currentToken = UrlToken.host(host);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == ':') {
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PORT: {
                    if (this.currentCharacter() == ':') {
                        this.nextCharacter();
                    }
                    String port = this.readUntilCharacter('/', '?');
                    this.currentToken = UrlToken.port(port);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PATH: {
                    String path = this.readUntilCharacter('?');
                    this.currentToken = UrlToken.path(path);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case QUERY: {
                    if (this.currentCharacter() == '?') {
                        this.nextCharacter();
                    }
                    String query = this.readRemaining();
                    this.currentToken = UrlToken.query(query);
                    this.state = UrlTokenizerState.DONE;
                    break;
                }
            }
        }
        return this.currentToken != null;
    }

    private String readUntilNotLetterOrDigit() {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char currentCharacter = this.currentCharacter();
            if (!Character.isLetterOrDigit(currentCharacter)) {
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readUntilCharacter(char ... terminatingCharacters) {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int start = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char currentCharacter = this.currentCharacter();
            for (char terminatingCharacter : terminatingCharacters) {
                if (currentCharacter != terminatingCharacter) continue;
                return this.text.substring(start, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(start);
    }

    private String readRemaining() {
        String result = "";
        if (this.currentIndex < this.textLength) {
            result = this.text.substring(this.currentIndex, this.textLength);
            this.currentIndex = this.textLength;
        }
        return result;
    }
}

