/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class QueryParameter {
    private final String name;
    private final String value;
    private List<String> values;
    private volatile String cachedStringValue;
    private static final AtomicReferenceFieldUpdater<QueryParameter, String> CACHED_STRING_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueryParameter.class, String.class, "cachedStringValue");

    QueryParameter(String name, String value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        this.name = name;
        this.value = value;
    }

    QueryParameter(String name, List<String> values) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(values, "'values' cannot be null");
        this.name = name;
        this.value = null;
        this.values = new LinkedList<String>(values);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        this.checkCachedStringValue();
        return this.cachedStringValue;
    }

    public String[] getValues() {
        if (this.values == null) {
            return new String[]{this.value};
        }
        return this.values.toArray(new String[0]);
    }

    public List<String> getValuesList() {
        if (this.values == null) {
            return Collections.singletonList(this.value);
        }
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String newValue) {
        if (this.values == null) {
            this.values = new LinkedList<String>();
            this.values.add(this.value);
        }
        this.values.add(newValue);
        CACHED_STRING_VALUE_UPDATER.set(this, null);
    }

    public String toString() {
        this.checkCachedStringValue();
        return this.name + "=" + CACHED_STRING_VALUE_UPDATER.get(this);
    }

    private void checkCachedStringValue() {
        CACHED_STRING_VALUE_UPDATER.compareAndSet(this, null, this.values == null ? this.value : CoreUtils.stringJoin(",", this.values));
    }
}

